/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.registry;

import com.ferreusveritas.dynamictrees.api.registry.AbstractRegistry;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;

public final class ConcurrentRegistry<V extends RegistryEntry<V>>
extends AbstractRegistry<V> {
    private final Map<ResourceLocation, V> entries = new ConcurrentHashMap<ResourceLocation, V>();

    public ConcurrentRegistry(Class<V> type, V nullValue) {
        this(type.getSimpleName(), type, nullValue);
    }

    public ConcurrentRegistry(String name, Class<V> type, V nullValue) {
        this(name, type, nullValue, false);
    }

    public ConcurrentRegistry(Class<V> type, V nullValue, boolean clearable) {
        this(type.getSimpleName(), type, nullValue, clearable);
    }

    public ConcurrentRegistry(String name, Class<V> type, V nullValue, boolean clearable) {
        super(name, type, nullValue, clearable);
        this.register(nullValue);
    }

    @Override
    public Registry<V> register(V value) {
        this.assertValid(value);
        this.entries.put(((RegistryEntry)value).getRegistryName(), value);
        return this;
    }

    @Override
    public Set<V> getAll() {
        return Collections.unmodifiableSet(new HashSet<V>(this.entries.values()));
    }

    @Override
    protected void clearAll() {
        this.entries.clear();
    }
}

