/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block.rooty;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.block.rooty.SoilHelper;
import com.ferreusveritas.dynamictrees.block.rooty.SoilProperties;
import com.ferreusveritas.dynamictrees.init.DTClient;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class SpreadableSoilProperties
extends SoilProperties {
    public static final TypedRegistry.EntryType<SoilProperties> TYPE = TypedRegistry.newType(SpreadableSoilProperties::new);
    private Integer required_light = null;
    private Item spread_item = null;
    private final List<SoilProperties> spreadable_soils = new LinkedList<SoilProperties>();

    public void setRequiredLight(Integer light) {
        this.required_light = light;
    }

    public void setSpreadItem(Item item) {
        this.spread_item = item;
    }

    public SpreadableSoilProperties(ResourceLocation registryName) {
        super(null, registryName);
    }

    @Override
    protected RootyBlock createBlock(BlockBehaviour.Properties blockProperties) {
        return new SpreadableRootyBlock(this, blockProperties);
    }

    public void addSpreadableSoils(Block ... blocks) {
        for (Block block : blocks) {
            SoilProperties props = SoilHelper.getProperties(block);
            if (!props.isValid()) continue;
            this.spreadable_soils.add(props);
        }
    }

    public void addSpreadableSoils(SoilProperties ... props) {
        this.spreadable_soils.addAll(Arrays.asList(props));
    }

    public static class SpreadableRootyBlock
    extends RootyBlock {
        public SpreadableRootyBlock(SpreadableSoilProperties properties, BlockBehaviour.Properties blockProperties) {
            super(properties, blockProperties);
        }

        @Override
        public SpreadableSoilProperties getSoilProperties() {
            return (SpreadableSoilProperties)super.getSoilProperties();
        }

        private Optional<RootyBlock> getRootyBlock(Block block) {
            return SoilHelper.getProperties(block).getBlock();
        }

        @Override
        public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            ItemStack handStack;
            SpreadableSoilProperties properties = this.getSoilProperties();
            if (properties.spread_item != null && (handStack = player.m_21120_(hand)).m_41720_().equals(properties.spread_item)) {
                LinkedList<Block> foundBlocks = new LinkedList<Block>();
                for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1))) {
                    Block block = level.m_8055_(blockpos).m_60734_();
                    if (!properties.spreadable_soils.stream().anyMatch(prop -> prop.getPrimitiveSoilBlock() == block)) continue;
                    foundBlocks.add(block);
                }
                if (foundBlocks.size() > 0) {
                    if (!level.m_5776_()) {
                        int blockInt = level.f_46441_.m_188503_(foundBlocks.size());
                        this.getRootyBlock((Block)foundBlocks.get(blockInt)).ifPresent(rootyBlock -> level.m_7731_(pos, rootyBlock.m_49966_(), 3));
                    }
                    if (!player.m_7500_()) {
                        handStack.m_41774_(1);
                    }
                    DTClient.spawnParticles(level, ParticleTypes.f_123748_, pos.m_7494_(), 2 + level.f_46441_.m_188503_(5), level.f_46441_);
                    return InteractionResult.SUCCESS;
                }
            }
            return super.m_6227_(state, level, pos, player, hand, hitResult);
        }

        @Override
        public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
            super.m_213898_(state, level, pos, random);
            SpreadableSoilProperties properties = this.getSoilProperties();
            if (!level.f_46443_ && properties.required_light != null) {
                if (!level.isAreaLoaded(pos, 3)) {
                    return;
                }
                if (level.m_46803_(pos.m_7494_()) >= properties.required_light) {
                    for (int i = 0; i < 4; ++i) {
                        BlockPos thatPos = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(5) - 3, random.m_188503_(3) - 1);
                        if (thatPos.m_123342_() >= 0 && thatPos.m_123342_() < 256 && !level.m_46805_(thatPos)) {
                            return;
                        }
                        BlockState thatStateUp = level.m_8055_(thatPos.m_7494_());
                        BlockState thatState = level.m_8055_(thatPos);
                        for (SoilProperties spreadable : properties.spreadable_soils) {
                            RootyBlock block = spreadable.getBlock().orElse(null);
                            if (block == null || thatState.m_60734_() != spreadable.getPrimitiveSoilBlock() && thatState.m_60734_() != block || level.m_46803_(pos.m_7494_()) < properties.required_light || thatStateUp.m_60739_((BlockGetter)level, thatPos.m_7494_()) > 2) continue;
                            if (state.m_61138_((Property)FERTILITY)) {
                                level.m_46597_(pos, (BlockState)block.m_49966_().m_61124_((Property)FERTILITY, (Comparable)((Integer)state.m_61143_((Property)FERTILITY))));
                            }
                            return;
                        }
                    }
                }
            }
        }
    }
}

