/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.api.applier.Applier;
import com.ferreusveritas.dynamictrees.api.applier.PropertyApplierResult;
import com.ferreusveritas.dynamictrees.api.applier.VoidApplier;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonPropertyAppliers;
import com.ferreusveritas.dynamictrees.deserialisation.result.JsonResult;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.ferreusveritas.dynamictrees.util.JsonMapWrapper;
import com.ferreusveritas.dynamictrees.util.holderset.DTBiomeHolderSet;
import com.ferreusveritas.dynamictrees.util.holderset.DelayedHolderSet;
import com.ferreusveritas.dynamictrees.util.holderset.NameRegexMatchHolderSet;
import com.ferreusveritas.dynamictrees.util.holderset.TagsRegexMatchHolderSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.holdersets.OrHolderSet;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BiomeListDeserialiser
implements JsonDeserialiser<DTBiomeHolderSet> {
    public static final Supplier<Registry<Biome>> DELAYED_BIOME_REGISTRY = () -> {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer == null) {
            throw new IllegalStateException("Queried biome registry too early; server does not exist yet!");
        }
        return currentServer.m_206579_().m_175515_(Registries.f_256952_);
    };
    private static final Applier<DTBiomeHolderSet, String> TAG_APPLIER = (biomeList, tagRegex) -> {
        boolean notOperator = BiomeListDeserialiser.usingNotOperator(tagRegex = tagRegex.toLowerCase(Locale.ENGLISH));
        if (notOperator) {
            tagRegex = tagRegex.substring(1);
        }
        if (tagRegex.charAt(0) == '#') {
            tagRegex = tagRegex.substring(1);
        }
        try {
            ResourceLocation tagLocation = new ResourceLocation(tagRegex);
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)tagLocation);
            (notOperator ? biomeList.getExcludeComponents() : biomeList.getIncludeComponents()).add(new DelayedHolderSet(() -> DELAYED_BIOME_REGISTRY.get().m_203561_(tagKey)));
        }
        catch (ResourceLocationException e) {
            return PropertyApplierResult.failure(e.getMessage());
        }
        return PropertyApplierResult.success();
    };
    private static final VoidApplier<DTBiomeHolderSet, String> NAME_APPLIER = (biomeList, nameRegex) -> {
        boolean notOperator = BiomeListDeserialiser.usingNotOperator(nameRegex = nameRegex.toLowerCase(Locale.ENGLISH));
        if (notOperator) {
            nameRegex = nameRegex.substring(1);
        }
        String finalNameRegex = nameRegex;
        (notOperator ? biomeList.getExcludeComponents() : biomeList.getIncludeComponents()).add(new DelayedHolderSet(() -> new NameRegexMatchHolderSet(DELAYED_BIOME_REGISTRY.get().m_255303_(), finalNameRegex)));
    };
    private static final VoidApplier<DTBiomeHolderSet, JsonArray> NAMES_OR_APPLIER = (biomeList, json) -> {
        List<String> nameRegexes = JsonResult.forInput((JsonElement)json).mapEachIfArray(String.class, String::toLowerCase).orElse(Collections.emptyList(), arg_0 -> ((Logger)LogManager.getLogger()).error(arg_0), arg_0 -> ((Logger)LogManager.getLogger()).warn(arg_0));
        ArrayList orIncludes = new ArrayList();
        ArrayList orExcludes = new ArrayList();
        nameRegexes.forEach(nameRegex -> {
            boolean notOperator = BiomeListDeserialiser.usingNotOperator(nameRegex = nameRegex.toLowerCase(Locale.ENGLISH));
            if (notOperator) {
                nameRegex = nameRegex.substring(1);
            }
            String finalNameRegex = nameRegex;
            (notOperator ? orExcludes : orIncludes).add(new DelayedHolderSet(() -> new NameRegexMatchHolderSet(DELAYED_BIOME_REGISTRY.get().m_255303_(), finalNameRegex)));
        });
        if (!orIncludes.isEmpty()) {
            biomeList.getIncludeComponents().add(new OrHolderSet(orIncludes));
        }
        if (!orExcludes.isEmpty()) {
            biomeList.getExcludeComponents().add(new OrHolderSet(orExcludes));
        }
    };
    private static final VoidApplier<DTBiomeHolderSet, JsonArray> TAGS_OR_APPLIER = (biomeList, json) -> {
        List<String> nameRegexes = JsonResult.forInput((JsonElement)json).mapEachIfArray(String.class, String::toLowerCase).orElse(Collections.emptyList(), arg_0 -> ((Logger)LogManager.getLogger()).error(arg_0), arg_0 -> ((Logger)LogManager.getLogger()).warn(arg_0));
        ArrayList orIncludes = new ArrayList();
        ArrayList orExcludes = new ArrayList();
        nameRegexes.forEach(tagRegex -> {
            boolean notOperator = BiomeListDeserialiser.usingNotOperator(tagRegex = tagRegex.toLowerCase(Locale.ENGLISH));
            if (notOperator) {
                tagRegex = tagRegex.substring(1);
            }
            if (tagRegex.charAt(0) == '#') {
                tagRegex = tagRegex.substring(1);
            }
            (notOperator ? orExcludes : orIncludes).add(new TagsRegexMatchHolderSet(DELAYED_BIOME_REGISTRY.get().m_255303_(), (String)tagRegex));
        });
        if (!orIncludes.isEmpty()) {
            biomeList.getIncludeComponents().add(new OrHolderSet(orIncludes));
        }
        if (!orExcludes.isEmpty()) {
            biomeList.getExcludeComponents().add(new OrHolderSet(orExcludes));
        }
    };
    private final VoidApplier<DTBiomeHolderSet, JsonObject> andOperator = (biomes, jsonObject) -> this.applyAllAppliers((JsonObject)jsonObject, (DTBiomeHolderSet)((Object)biomes));
    private final VoidApplier<DTBiomeHolderSet, JsonArray> orOperator = (biomeList, json) -> {
        LinkedList appliedList = new LinkedList();
        JsonResult.forInput((JsonElement)json).mapEachIfArray(JsonObject.class, object -> {
            DTBiomeHolderSet subList = new DTBiomeHolderSet();
            this.applyAllAppliers((JsonObject)object, subList);
            appliedList.add(subList);
            return object;
        }).orElse(null, arg_0 -> ((Logger)LogManager.getLogger()).error(arg_0), arg_0 -> ((Logger)LogManager.getLogger()).warn(arg_0));
        if (!appliedList.isEmpty()) {
            biomeList.getIncludeComponents().add(new OrHolderSet(appliedList));
        }
    };
    private final VoidApplier<DTBiomeHolderSet, JsonObject> notOperator = (biomeList, jsonObject) -> {
        DTBiomeHolderSet notBiomeList = new DTBiomeHolderSet();
        this.applyAllAppliers((JsonObject)jsonObject, notBiomeList);
        biomeList.getExcludeComponents().add(notBiomeList);
    };
    private final JsonPropertyAppliers<DTBiomeHolderSet> appliers = new JsonPropertyAppliers<DTBiomeHolderSet>(DTBiomeHolderSet.class);

    private static boolean usingNotOperator(String categoryString) {
        return categoryString.charAt(0) == '!';
    }

    public BiomeListDeserialiser() {
        this.registerAppliers();
    }

    private void registerAppliers() {
        ((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)this.appliers.register("tag", (Class)String.class, TAG_APPLIER)).registerArrayApplier("tags", (Class)String.class, (Applier)TAG_APPLIER)).register("tags_or", (Class)JsonArray.class, (VoidApplier)TAGS_OR_APPLIER)).register("name", (Class)String.class, (VoidApplier)NAME_APPLIER)).registerArrayApplier("names", (Class)String.class, (VoidApplier)NAME_APPLIER)).register("names_or", (Class)JsonArray.class, (VoidApplier)NAMES_OR_APPLIER)).registerArrayApplier("AND", (Class)JsonObject.class, (VoidApplier)this.andOperator)).register("OR", (Class)JsonArray.class, (VoidApplier)this.orOperator)).register("NOT", (Class)JsonObject.class, (VoidApplier)this.notOperator);
    }

    private void applyAllAppliers(JsonObject json, DTBiomeHolderSet biomes) {
        this.appliers.applyAll(new JsonMapWrapper(json), biomes);
    }

    @Override
    public Result<DTBiomeHolderSet, JsonElement> deserialise(JsonElement input) {
        return JsonResult.forInput(input).mapIfType(String.class, biomeName -> {
            DTBiomeHolderSet biomes = new DTBiomeHolderSet();
            biomes.getIncludeComponents().add(new DelayedHolderSet(() -> new NameRegexMatchHolderSet(DELAYED_BIOME_REGISTRY.get().m_255303_(), biomeName.toLowerCase(Locale.ENGLISH))));
            return biomes;
        }).elseMapIfType(JsonObject.class, selectorObject -> {
            DTBiomeHolderSet biomes = new DTBiomeHolderSet();
            this.applyAllAppliers((JsonObject)selectorObject, biomes);
            return biomes;
        }).elseTypeError();
    }
}

