/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.event.handler;

import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.systems.poissondisc.UniversalPoissonDiscProvider;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabases;
import com.ferreusveritas.dynamictrees.worldgen.DynamicTreeFeature;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WorldGenEventHandler {
    public static final String CIRCLE_DATA_ID = "GTCD";

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        BiomeDatabases.populateBlacklistFromConfig();
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        LevelAccessor level = event.getLevel();
        if (!level.m_5776_()) {
            DynamicTreeFeature.DISC_PROVIDER.unloadWorld((ServerLevel)level);
        }
    }

    @SubscribeEvent
    public void onChunkDataLoad(ChunkDataEvent.Load event) {
        if (!((Boolean)DTConfigs.WORLD_GEN.get()).booleanValue()) {
            return;
        }
        LevelAccessor level = event.getLevel();
        if (level == null || level.m_5776_()) {
            return;
        }
        byte[] circleData = event.getData().m_128463_(CIRCLE_DATA_ID);
        UniversalPoissonDiscProvider discProvider = DynamicTreeFeature.DISC_PROVIDER;
        ChunkPos chunkPos = event.getChunk().m_7697_();
        discProvider.setChunkPoissonData(LevelContext.create(level), chunkPos, circleData);
    }

    @SubscribeEvent
    public void onChunkDataSave(ChunkDataEvent.Save event) {
        if (!((Boolean)DTConfigs.WORLD_GEN.get()).booleanValue()) {
            return;
        }
        LevelContext levelContext = LevelContext.create(event.getLevel());
        UniversalPoissonDiscProvider discProvider = DynamicTreeFeature.DISC_PROVIDER;
        ChunkAccess chunk = event.getChunk();
        ChunkPos chunkPos = chunk.m_7697_();
        byte[] circleData = discProvider.getChunkPoissonData(levelContext, chunkPos);
        event.getData().m_128382_(CIRCLE_DATA_ID, circleData);
        if (chunk instanceof LevelChunk && !((LevelChunk)chunk).f_62775_) {
            discProvider.unloadChunkPoissonData(levelContext, chunkPos);
        }
    }
}

