/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.growthlogic;

import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class DarkOakLogic
extends GrowthLogicKit {
    public DarkOakLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = super.populateDirectionProbabilityMap(configuration, context);
        probMap[Direction.UP.m_122411_()] = 4;
        if (!context.signal().isInTrunk()) {
            probMap[Direction.UP.m_122411_()] = 0;
            probMap[Direction.DOWN.m_122411_()] = 0;
            int n = context.signal().dir.ordinal();
            probMap[n] = (int)((double)probMap[n] * 0.35);
        }
        float energyRatio = (float)context.signal().delta.m_123342_() / context.species().getEnergy(context.level(), context.pos());
        float spreadPush = energyRatio * 2.0f;
        spreadPush = Math.max(spreadPush, 1.0f);
        for (Direction dir : CoordUtils.HORIZONTALS) {
            int n = dir.ordinal();
            probMap[n] = (int)((float)probMap[n] * spreadPush);
        }
        if (context.signal().numTurns == 1 && context.signal().delta.m_203198_(0.0, (double)context.signal().delta.m_123342_(), 0.0) == 1.0) {
            for (Direction dir : CoordUtils.HORIZONTALS) {
                if (context.signal().dir == dir) continue;
                probMap[dir.ordinal()] = 0;
            }
        }
        if (context.signal().isInTrunk()) {
            for (Direction dir : CoordUtils.HORIZONTALS) {
                if (probMap[dir.ordinal()] < 7) continue;
                probMap[dir.ordinal()] = 2;
            }
            if (context.signal().delta.m_123342_() > context.species().getLowestBranchHeight() + 5) {
                probMap[Direction.UP.ordinal()] = 0;
                context.signal().energy = 2.0f;
            }
        }
        return probMap;
    }

    @Override
    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return super.getEnergy(configuration, context) * context.species().biomeSuitability(context.level(), context.pos());
    }

    @Override
    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return (int)((float)super.getLowestBranchHeight(configuration, context) * context.species().biomeSuitability(context.level(), context.pos()));
    }
}

