/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.tree.family;

import com.ferreusveritas.dynamictrees.api.cell.Cell;
import com.ferreusveritas.dynamictrees.api.cell.CellNull;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BasicBranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.leaves.PalmLeavesProperties;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.PalmSpecies;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;

public class PalmFamily
extends Family {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(PalmFamily::new);

    public PalmFamily(ResourceLocation name) {
        super(name);
    }

    @Override
    public void setCommonSpecies(Species species) {
        super.setCommonSpecies(species);
        if (!(species instanceof PalmSpecies)) {
            LogManager.getLogger().warn("Common species " + String.valueOf(species.getRegistryName()) + " for palm family " + String.valueOf(this.getRegistryName()) + "is not of type " + String.valueOf(PalmSpecies.class));
        }
    }

    @Override
    public void setCommonLeaves(LeavesProperties properties) {
        super.setCommonLeaves(properties);
        if (!(properties instanceof PalmLeavesProperties)) {
            LogManager.getLogger().warn("Common leaves properties " + String.valueOf(properties.getRegistryName()) + " for palm family " + String.valueOf(this.getRegistryName()) + "is not of type " + String.valueOf(PalmLeavesProperties.class));
        }
    }

    @Override
    protected BranchBlock createBranchBlock(ResourceLocation name) {
        BasicBranchBlock branch = new BasicBranchBlock(name, this.getProperties()){

            @Override
            public Cell getHydrationCell(BlockGetter level, BlockPos pos, BlockState state, Direction dir, LeavesProperties leavesProperties) {
                if (this.getRadius(state) != this.getFamily().getPrimaryThickness()) {
                    return CellNull.NULL_CELL;
                }
                return super.getHydrationCell(level, pos, state, dir, leavesProperties);
            }

            @Override
            public GrowSignal growIntoAir(Level world, BlockPos pos, GrowSignal signal, int fromRadius) {
                Species species = signal.getSpecies();
                DynamicLeavesBlock leaves = species.getLeavesBlock().orElse(null);
                if (leaves != null) {
                    if (fromRadius == this.getFamily().getPrimaryThickness()) {
                        if (1.isNextToBranch(world, pos, signal.dir.m_122424_())) {
                            signal.success = false;
                            return signal;
                        }
                        signal.success = leaves.growLeavesIfLocationIsSuitable((LevelAccessor)world, species.getLeavesProperties(), pos.m_7494_(), 0);
                        if (signal.success) {
                            return leaves.branchOut(world, pos, signal);
                        }
                    } else {
                        return leaves.branchOut(world, pos, signal);
                    }
                }
                return super.growIntoAir(world, pos, signal, fromRadius);
            }
        };
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }
}

