/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.api.configuration;

import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.deserializer.JsonDeserializer;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ConfigurationProperty<T> {
    public static final ConfigurationProperty<Object> NULL = new ConfigurationProperty<Object>("null", Object.class);
    private final String key;
    private final Class<T> type;

    protected ConfigurationProperty(String key, Class<T> type) {
        this.key = key;
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Optional<Result<T, JsonElement>> deserialise(JsonObject jsonObject) {
        JsonElement jsonElement = jsonObject.get(this.key);
        if (jsonElement == null) {
            return Optional.empty();
        }
        JsonDeserializer<T> getter = JsonDeserializers.getOrThrow(this.type, "Tried to get class \"" + this.type.getName() + "\" for gen feature property \"" + this.key + "\", but deserialiser was not registered.");
        return Optional.of(getter.deserialize(jsonElement));
    }

    public static <T> ConfigurationProperty<T> property(String identifier, @NotNull Class<T> type) {
        Objects.requireNonNull(type);
        return new ConfigurationProperty<T>(identifier, type);
    }

    public static ConfigurationProperty<String> string(String identifier) {
        return ConfigurationProperty.property(identifier, String.class);
    }

    public static ConfigurationProperty<Boolean> bool(String identifier) {
        return ConfigurationProperty.property(identifier, Boolean.class);
    }

    public static ConfigurationProperty<Integer> integer(String identifier) {
        return ConfigurationProperty.property(identifier, Integer.class);
    }

    public static ConfigurationProperty<Long> longProperty(String identifier) {
        return ConfigurationProperty.property(identifier, Long.class);
    }

    public static ConfigurationProperty<Float> doubleProperty(String identifier) {
        return ConfigurationProperty.property(identifier, Float.class);
    }

    public static ConfigurationProperty<Float> floatProperty(String identifier) {
        return ConfigurationProperty.property(identifier, Float.class);
    }

    public static ConfigurationProperty<Block> block(String identifier) {
        return ConfigurationProperty.property(identifier, Block.class);
    }

    public static ConfigurationProperty<Item> item(String identifier) {
        return ConfigurationProperty.property(identifier, Item.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationProperty that = (ConfigurationProperty)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.type);
    }

    public String toString() {
        return "ConfigurationProperty{identifier='" + this.key + "', type=" + String.valueOf(this.type) + "}";
    }
}

