/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.api.resource.loading;

import com.dtteam.dynamictrees.api.resource.loading.AbstractResourceLoader;
import com.dtteam.dynamictrees.api.resource.loading.ApplierResourceLoader;
import com.dtteam.dynamictrees.api.resource.loading.preparation.ResourcePreparer;
import com.dtteam.dynamictrees.deserialization.PropertyAppliers;
import com.dtteam.dynamictrees.platform.Services;
import java.util.function.Function;

public abstract class StagedApplierResourceLoader<I, R>
extends AbstractResourceLoader<I>
implements ApplierResourceLoader<I> {
    protected final PropertyAppliers<R, I> loadAppliers;
    protected final PropertyAppliers<R, I> gatherDataAppliers;
    protected final PropertyAppliers<R, I> setupAppliers;
    protected final PropertyAppliers<R, I> reloadAppliers;
    protected final PropertyAppliers<R, I> commonAppliers;
    protected final String appliersIdentifier;

    public StagedApplierResourceLoader(ResourcePreparer<I> resourcePreparer, Class<R> resourceType, Function<Class<R>, PropertyAppliers<R, I>> appliersConstructor, String appliersIdentifier) {
        super(resourcePreparer);
        this.loadAppliers = appliersConstructor.apply(resourceType);
        this.gatherDataAppliers = appliersConstructor.apply(resourceType);
        this.setupAppliers = appliersConstructor.apply(resourceType);
        this.reloadAppliers = appliersConstructor.apply(resourceType);
        this.commonAppliers = appliersConstructor.apply(resourceType);
        this.appliersIdentifier = appliersIdentifier;
    }

    @Override
    public void registerAppliers() {
        Services.EVENT.postApplierEvent(ApplierStage.LOAD, this.loadAppliers, this.appliersIdentifier);
        Services.EVENT.postApplierEvent(ApplierStage.GATHER_DATA, this.gatherDataAppliers, this.appliersIdentifier);
        Services.EVENT.postApplierEvent(ApplierStage.SETUP, this.setupAppliers, this.appliersIdentifier);
        Services.EVENT.postApplierEvent(ApplierStage.RELOAD, this.reloadAppliers, this.appliersIdentifier);
        Services.EVENT.postApplierEvent(ApplierStage.COMMON, this.commonAppliers, this.appliersIdentifier);
    }

    public static enum ApplierStage {
        LOAD,
        GATHER_DATA,
        SETUP,
        RELOAD,
        COMMON;

    }
}

