/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.pod;

import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.block.Growable;
import com.dtteam.dynamictrees.block.pod.Pod;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.season.SeasonHelper;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PodBlock
extends HorizontalDirectionalBlock
implements BonemealableBlock,
Growable {
    public static final MapCodec<PodBlock> CODEC = PodBlock.simpleCodec(PodBlock::new);
    protected final Pod pod;

    public PodBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.pod = Pod.NULL;
    }

    public PodBlock(BlockBehaviour.Properties properties, Pod pod) {
        super(properties);
        this.pod = pod;
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder);
        this.stateDefinition = builder.create(Block::defaultBlockState, BlockState::new);
        this.registerDefaultState((BlockState)this.stateDefinition.any());
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        if (this.pod != null) {
            builder.add(new Property[]{this.pod.getAgeProperty()});
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.pod.getBlockShape(this.getFacing(state), this.getAge(state));
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.doTick(state, (Level)level, pos, random);
    }

    public void doTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!this.isSupported((LevelReader)level, pos, state)) {
            this.drop((LevelAccessor)level, pos, state);
            return;
        }
        int age = this.getAge(state);
        Float season = SeasonHelper.getSeasonValue(LevelContext.create((LevelAccessor)level), pos);
        if (season != null) {
            if (this.pod.isOutOfSeason(LevelContext.create((LevelAccessor)level), pos)) {
                this.outOfSeason(level, pos);
                return;
            }
            if (age == 0 && this.pod.isInFlowerHoldPeriod((LevelAccessor)level, pos, season)) {
                return;
            }
        }
        if (age < this.pod.getMaxAge()) {
            this.tryGrow(state, level, pos, random, age, season);
        } else {
            this.tickMature(level, pos, state);
        }
    }

    private void outOfSeason(Level level, BlockPos pos) {
        level.destroyBlock(pos, false);
    }

    private void tryGrow(BlockState state, Level level, BlockPos pos, RandomSource random, int age, @Nullable Float season) {
        boolean doGrow = random.nextFloat() < this.getGrowthChance(level, pos);
        boolean eventGrow = Services.EVENT.canCropGrow(level, pos, state, doGrow);
        if (season != null ? doGrow || eventGrow : eventGrow) {
            this.setAge(level, pos, state, age + 1);
            Services.EVENT.cropGrowPost(level, pos, state);
        }
    }

    private float getGrowthChance(Level level, BlockPos pos) {
        return this.pod.getGrowthChance();
    }

    public void tickMature(Level level, BlockPos pos, BlockState state) {
        this.pod.performMatureAction(new Growable.Info((LevelAccessor)level, pos, state));
    }

    @Override
    public void performMatureAction(LevelAccessor level, BlockPos pos, BlockState state) {
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (!this.isSupported((LevelReader)level, pos, state)) {
            this.drop((LevelAccessor)level, pos, state);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.isSupported(level, pos, state);
    }

    @Override
    public boolean isSupported(LevelReader level, BlockPos pos, BlockState state) {
        BlockState branchState = level.getBlockState(pos.relative((Direction)state.getValue((Property)FACING)));
        return TreeHelper.getBranchOpt(branchState).map(branch -> this.pod.isValidRadius(branch.getRadius(branchState))).orElse(false);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return this.pod.getItemStack();
    }

    public boolean harvest(BlockState state, Level level, BlockPos pos) {
        if (this.getAge(state) >= this.pod.getMaxAge()) {
            this.drop((LevelAccessor)level, pos, state);
            return true;
        }
        return false;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.harvest(state, level, pos) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.harvest(state, level, pos) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return this.pod.canBoneMeal() && this.getAge(blockState) < this.pod.getMaxAge();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int age = this.getAge(state);
        int newAge = Math.min(age + 1, this.pod.getMaxAge());
        if (newAge != age) {
            this.setAge((Level)level, pos, state, newAge);
        }
    }

    private Direction getFacing(BlockState state) {
        return (Direction)state.getValue((Property)FACING);
    }

    public int getAge(BlockState state) {
        return (Integer)state.getValue((Property)this.pod.getAgeProperty());
    }

    public float getAgeAsPercentage(BlockState state) {
        return (float)this.getAge(state) * 100.0f / (float)this.getMaxAge();
    }

    public int getMaxAge() {
        return this.pod.getMaxAge();
    }

    private void setAge(Level level, BlockPos pos, BlockState state, int newAge) {
        level.setBlock(pos, (BlockState)state.setValue((Property)this.pod.getAgeProperty(), (Comparable)Integer.valueOf(newAge)), 2);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)this.pod.getAgeProperty(), (Comparable)Integer.valueOf(0));
        BlockPos pos = context.getClickedPos();
        for (Direction direction : context.getNearestLookingDirections()) {
            if (!direction.getAxis().isHorizontal() || !(state = (BlockState)state.setValue((Property)FACING, (Comparable)direction)).canSurvive((LevelReader)context.getLevel(), pos)) continue;
            return state;
        }
        return null;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

