/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.sapling;

import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.CoordUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class DynamicSaplingBlock
extends Block
implements BonemealableBlock {
    public static final Map<Block, Species> SAPLING_REPLACERS = new HashMap<Block, Species>();
    protected Species species;

    public DynamicSaplingBlock(Species species) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().pushReaction(PushReaction.DESTROY).instabreak().sound(SoundType.GRASS).randomTicks().noOcclusion());
        this.species = species;
    }

    public Species getSpecies() {
        return this.species;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.getSpecies().saplingFireSpread();
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.getSpecies().saplingFlammability();
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.getSpecies().canSaplingGrowNaturally((Level)level, pos)) {
            this.performBonemeal(level, random, pos, state);
        }
    }

    public static boolean canSaplingStay(LevelReader level, Species species, BlockPos pos) {
        for (Direction dir : CoordUtils.HORIZONTALS) {
            BlockState blockState = level.getBlockState(pos.relative(dir));
            Block block = blockState.getBlock();
            if (!TreeHelper.isBranch(block) && !(block instanceof DynamicSaplingBlock)) continue;
            return false;
        }
        return level.isEmptyBlock(pos.above()) && species.isAcceptableSoil(level, pos.below(), level.getBlockState(pos.below()));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return DynamicSaplingBlock.canSaplingStay(level, this.getSpecies(), pos);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return this.getSpecies().canSaplingConsumeBoneMeal(levelReader, blockPos);
    }

    public boolean isBonemealSuccess(@NotNull Level level, @NotNull RandomSource rand, @NotNull BlockPos pos, @NotNull BlockState state) {
        return this.getSpecies().canSaplingGrowAfterBoneMeal(level, rand, pos);
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource rand, @NotNull BlockPos pos, @NotNull BlockState state) {
        if (this.canSurvive(state, (LevelReader)level, pos)) {
            Species species = this.getSpecies().selfOrLocationOverride((BlockGetter)level, pos);
            if (species.canSaplingGrow((LevelReader)level, pos)) {
                species.transitionToTree((Level)level, pos);
            }
        } else {
            this.dropBlock((Level)level, state, pos);
        }
    }

    protected SoundType getSoundType(BlockState state) {
        return this.getSpecies().getSaplingSound();
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            this.dropBlock(level, state, pos);
        }
    }

    protected void dropBlock(Level level, BlockState state, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.getDrops(state, new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY)).forEach(drop -> DynamicSaplingBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)drop));
            level.removeBlock(pos, false);
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return this.getSpecies().getSeedStack(1);
    }

    public List<ItemStack> getDrops(@NotNull BlockState state, @NotNull LootParams.Builder builder) {
        if (!Services.CONFIG.getBoolConfig("dynamicSaplingDrops").booleanValue()) {
            return Collections.emptyList();
        }
        LootTable loottable = builder.getLevel().getServer().reloadableRegistries().getLootTable(this.getLootTable());
        if (loottable == LootTable.EMPTY) {
            return Collections.singletonList(this.getSpecies().getSeedStack(1));
        }
        return super.getDrops(state, builder);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getSpecies().getSaplingShape();
    }

    public static void registerSaplingReplacer(BlockState state, Species species) {
        SAPLING_REPLACERS.put(state.getBlock(), species);
    }
}

