/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.soil;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.lazyvalue.MutableLazyValue;
import com.dtteam.dynamictrees.api.registry.RegistryEntry;
import com.dtteam.dynamictrees.api.registry.RegistryHandler;
import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.block.soil.SoilHelper;
import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.data.tags.DTBlockTags;
import com.dtteam.dynamictrees.treepack.Resettable;
import com.dtteam.dynamictrees.utility.Optionals;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;

public class SoilProperties
extends RegistryEntry<SoilProperties>
implements Resettable<SoilProperties> {
    public static final HashMap<ResourceLocation, Supplier<Generator<DTDataProvider.BlockState, SoilProperties>>> blockStateGenerators = new HashMap();
    public static final HashMap<ResourceLocation, Supplier<Generator<DTDataProvider.ItemModel, SoilProperties>>> itemModelGenerators = new HashMap();
    public static final HashMap<ResourceLocation, Supplier<Generator<DTDataProvider.Language, SoilProperties>>> languageGenerators = new HashMap();
    public static final Codec<SoilProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf(TypedRegistry.RESOURCE_LOCATION.toString()).forGetter(RegistryEntry::getRegistryName)).apply((Applicative)instance, SoilProperties::new));
    public static final SoilProperties NULL_SOIL_PROPERTIES = ((SoilProperties)new SoilProperties(){

        @Override
        public Block getPrimitiveSoilBlock() {
            return Blocks.AIR;
        }

        @Override
        public Optional<SoilBlock> getBlock() {
            return Optional.empty();
        }

        @Override
        public Integer getSoilFlags() {
            return 0;
        }

        @Override
        public void generateBlock(BlockBehaviour.Properties properties) {
        }
    }.setRegistryName(DynamicTrees.NULL)).setBlockRegistryName(DynamicTrees.NULL);
    public static final TypedRegistry<SoilProperties> REGISTRY = new TypedRegistry<SoilProperties>(SoilProperties.class, NULL_SOIL_PROPERTIES, new TypedRegistry.EntryType<SoilProperties>(CODEC));
    protected Block primitiveSoilBlock;
    protected Supplier<SoilBlock> block;
    protected Integer soilFlags = 0;
    private ResourceLocation blockRegistryName;
    protected boolean hasSubstitute;
    protected List<String> onlyIfLoaded = new ArrayList<String>();
    protected int foliageTintIndex = 0;
    protected int rootsTintIndex = 1;
    protected final MutableLazyValue<Generator<DTDataProvider.BlockState, SoilProperties>> soilStateGenerator = MutableLazyValue.supplied(blockStateGenerators.get(DynamicTrees.location("soil")));
    protected HashMap<String, ResourceLocation> textureOverrides = new HashMap();
    protected HashMap<String, ResourceLocation> modelOverrides = new HashMap();
    public static final String ROOTS = "roots";
    public static final String SOIL_BLOCK = "soil_block";

    protected SoilProperties() {
    }

    protected SoilProperties(Block primitiveBlock, ResourceLocation name, Integer soilFlags, boolean generate) {
        this(primitiveBlock, name);
        this.soilFlags = soilFlags;
        if (generate) {
            this.generateBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)primitiveBlock));
        }
    }

    public SoilProperties(ResourceLocation registryName) {
        this(null, registryName);
    }

    public SoilProperties(@Nullable Block primitiveBlock, ResourceLocation registryName) {
        super(registryName);
        this.primitiveSoilBlock = primitiveBlock != null ? primitiveBlock : Blocks.AIR;
    }

    public Block getPrimitiveSoilBlock() {
        return this.primitiveSoilBlock;
    }

    public Optional<Block> getPrimitiveSoilBlockOptional() {
        return Optionals.ofBlock(this.primitiveSoilBlock);
    }

    public void setPrimitiveSoilBlock(Block primitiveSoil) {
        if (this.primitiveSoilBlock != null && (primitiveSoil == null || primitiveSoil == Blocks.AIR)) {
            return;
        }
        if (this.primitiveSoilBlock == null || primitiveSoil != this.primitiveSoilBlock) {
            this.primitiveSoilBlock = primitiveSoil;
        }
        SoilHelper.addSoilPropertiesToMap(this);
    }

    public boolean isValidState(BlockState primitiveSoilState) {
        return true;
    }

    public BlockState getSoilState(BlockState primitiveSoilState, int fertility, boolean requireTileEntity) {
        return (BlockState)((BlockState)this.block.get().defaultBlockState().setValue((Property)SoilBlock.FERTILITY, (Comparable)Integer.valueOf(fertility))).setValue((Property)SoilBlock.IS_VARIANT, (Comparable)Boolean.valueOf(requireTileEntity));
    }

    public BlockState getPrimitiveSoilState(BlockState currentSoilState) {
        return this.primitiveSoilBlock.defaultBlockState();
    }

    public boolean inheritsPrimitiveProperties() {
        return true;
    }

    protected String getBlockRegistryNamePrefix() {
        return "rooty_";
    }

    public ResourceLocation getBlockRegistryName() {
        return this.blockRegistryName;
    }

    public SoilProperties setBlockRegistryName(ResourceLocation blockRegistryName) {
        this.blockRegistryName = blockRegistryName;
        return this;
    }

    private void setBlockRegistryNameIfNull() {
        if (this.blockRegistryName == null) {
            this.blockRegistryName = ResourceLocationUtils.prefix(this.getRegistryName(), this.getBlockRegistryNamePrefix());
        }
    }

    public Optional<SoilBlock> getBlock() {
        if (this.block == null) {
            return Optional.empty();
        }
        return Optionals.ofBlock(this.block.get());
    }

    public void generateBlock(BlockBehaviour.Properties blockProperties) {
        this.setBlockRegistryNameIfNull();
        this.block = RegistryHandler.addBlock(this.blockRegistryName, () -> this.createBlock(blockProperties));
    }

    protected SoilBlock createBlock(BlockBehaviour.Properties blockProperties) {
        return new SoilBlock(this, blockProperties);
    }

    public void setBlock(SoilBlock soilBlock) {
        this.block = () -> soilBlock;
    }

    public boolean hasSubstitute() {
        return this.hasSubstitute;
    }

    public void setHasSubstitute(boolean hasSubstitute) {
        this.hasSubstitute = hasSubstitute;
    }

    public void setFoliageTintIndex(int foliageTintIndex) {
        this.foliageTintIndex = foliageTintIndex;
    }

    public void setRootsTintIndex(int rootsTintIndex) {
        this.rootsTintIndex = rootsTintIndex;
    }

    public MapColor getDefaultMapColor() {
        return MapColor.DIRT;
    }

    public BlockBehaviour.Properties getDefaultBlockProperties(MapColor mapColor) {
        return BlockBehaviour.Properties.of().mapColor(mapColor).strength(0.5f).sound(SoundType.GRAVEL);
    }

    public Integer getSoilFlags() {
        return this.soilFlags;
    }

    public SoilProperties setSoilFlags(Integer adjFlag) {
        this.soilFlags = adjFlag;
        return this;
    }

    public SoilProperties addSoilFlags(Integer adjFlag) {
        this.soilFlags = this.soilFlags | adjFlag;
        return this;
    }

    @Override
    public void generateStateData(DTDataProvider.BlockState provider) {
        this.soilStateGenerator.get().generate(provider, this);
    }

    public void setTextureOverrides(Map<String, ResourceLocation> textureOverrides) {
        this.textureOverrides.putAll(textureOverrides);
    }

    public Optional<ResourceLocation> getTexturePath(String key) {
        return Optional.ofNullable(this.textureOverrides.getOrDefault(key, null));
    }

    public void setModelOverrides(Map<String, ResourceLocation> modelOverrides) {
        this.modelOverrides.putAll(modelOverrides);
    }

    public Optional<ResourceLocation> getModelPath(String key) {
        return Optional.ofNullable(this.modelOverrides.getOrDefault(key, null));
    }

    public ResourceLocation getRootsOverlayModelLocation() {
        if (this.modelOverrides.containsKey(ROOTS)) {
            return this.modelOverrides.get(ROOTS);
        }
        return DynamicTrees.location("block/roots");
    }

    public List<TagKey<Block>> defaultSoilBlockTags() {
        return Collections.singletonList(DTBlockTags.ROOTY_SOIL);
    }

    public boolean isOnlyIfLoaded() {
        return !this.onlyIfLoaded.isEmpty();
    }

    public void setOnlyIfLoaded(String onlyIfLoaded) {
        this.onlyIfLoaded.add(onlyIfLoaded);
    }

    public void addGeneratedBlockTags(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagAppender) {
        this.getBlock().ifPresent(rootyBlock -> this.defaultSoilBlockTags().forEach(tag -> {
            if (!this.isOnlyIfLoaded()) {
                ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).add(rootyBlock);
            } else {
                ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).addOptional(BuiltInRegistries.BLOCK.getKey(rootyBlock));
            }
        }));
    }

    @Override
    public String toString() {
        return this.getRegistryName().toString();
    }
}

