/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.client;

import com.dtteam.dynamictrees.entity.FallingTreeEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class SoundInstanceHandler {
    private static final Map<Integer, SoundInstance> instances = new HashMap<Integer, SoundInstance>();

    public static void playSoundInstance(SoundEvent sound, float pitch, Vec3 pos, FallingTreeEntity entity) {
        SoundInstanceHandler.playSoundInstance(sound, SoundSource.NEUTRAL, 1.0f, pitch, pos, entity);
    }

    public static void playSoundInstance(SoundEvent sound, SoundSource source, float volume, float pitch, Vec3 pos, FallingTreeEntity entity) {
        SimpleSoundInstance instance = new SimpleSoundInstance(sound, source, volume, pitch, RandomSource.create(), pos.x, pos.y, pos.z);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)instance);
        instances.put(entity.getId(), (SoundInstance)instance);
    }

    public static void stopSoundInstance(FallingTreeEntity entity) {
        if (entity == null || !instances.containsKey(entity.getId())) {
            return;
        }
        SoundInstance instance = instances.get(entity.getId());
        if (instance == null) {
            return;
        }
        Minecraft.getInstance().getSoundManager().stop(instance);
        instances.remove(entity.getId());
        instances.keySet().removeIf(id -> entity.level().getEntity(id.intValue()) == null);
    }
}

