/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.command.subcommand;

import com.dtteam.dynamictrees.api.function.ThrowableRunnable;
import com.dtteam.dynamictrees.block.sapling.DynamicSaplingBlock;
import com.dtteam.dynamictrees.command.CommandHelper;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class SubCommand {
    protected static final DynamicCommandExceptionType NO_TREE_FOUND = new DynamicCommandExceptionType(pos -> Component.translatable((String)"commands.dynamictrees.error.get_tree", (Object[])new Object[]{Component.translatable((String)"chat.coordinates", (Object[])new Object[]{SubCommand.getVector3i(pos).getX(), SubCommand.getVector3i(pos).getY(), SubCommand.getVector3i(pos).getZ()}).withStyle(style -> style.withColor(ChatFormatting.DARK_RED))}));
    protected static final DynamicCommandExceptionType SPECIES_UNKNOWN = new DynamicCommandExceptionType(resLocStr -> Component.translatable((String)"commands.dynamictrees.error.unknown_species", (Object[])new Object[]{SubCommand.darkRed(resLocStr)}));

    private static Vec3i getVector3i(Object vecObj) {
        if (vecObj instanceof Vec3i) {
            return (Vec3i)vecObj;
        }
        return Vec3i.ZERO;
    }

    protected abstract String getName();

    protected abstract int getPermissionLevel();

    public ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder argumentBuilder = (LiteralArgumentBuilder)Commands.literal((String)this.getName()).requires(commandSource -> commandSource.hasPermission(this.getPermissionLevel()));
        this.registerArguments().forEach(arg_0 -> ((LiteralArgumentBuilder)argumentBuilder).then(arg_0));
        return argumentBuilder;
    }

    protected List<ArgumentBuilder<CommandSourceStack, ?>> registerArguments() {
        return Lists.newArrayList((Object[])new ArgumentBuilder[]{this.registerArgument()});
    }

    public abstract ArgumentBuilder<CommandSourceStack, ?> registerArgument();

    protected static int executesSuccess(ThrowableRunnable<CommandSyntaxException> executeRunnable) throws CommandSyntaxException {
        executeRunnable.run();
        return 1;
    }

    protected static int executesSuccess(CommandContext<CommandSourceStack> context, Consumer<CommandContext<CommandSourceStack>> executeConsumer) {
        executeConsumer.accept(context);
        return 1;
    }

    protected static RequiredArgumentBuilder<CommandSourceStack, Boolean> booleanArgument(String name) {
        return Commands.argument((String)name, (ArgumentType)BoolArgumentType.bool());
    }

    protected static boolean booleanArgument(CommandContext<CommandSourceStack> context, String name) {
        return BoolArgumentType.getBool(context, (String)name);
    }

    protected static RequiredArgumentBuilder<CommandSourceStack, Integer> intArgument(String name) {
        return Commands.argument((String)name, (ArgumentType)IntegerArgumentType.integer());
    }

    protected static int intArgument(CommandContext<CommandSourceStack> context, String name) {
        return IntegerArgumentType.getInteger(context, (String)name);
    }

    protected static RequiredArgumentBuilder<CommandSourceStack, String> stringArgument(String name) {
        return Commands.argument((String)name, (ArgumentType)StringArgumentType.string());
    }

    protected static RequiredArgumentBuilder<CommandSourceStack, String> stringArgument(String name, Collection<String> suggestions) {
        return Commands.argument((String)name, (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)suggestions, (SuggestionsBuilder)builder));
    }

    protected static String stringArgument(CommandContext<CommandSourceStack> context, String name) {
        return StringArgumentType.getString(context, (String)name);
    }

    protected static RequiredArgumentBuilder<CommandSourceStack, Coordinates> blockPosArgument() {
        return Commands.argument((String)"location", (ArgumentType)BlockPosArgument.blockPos());
    }

    protected static BlockPos blockPosArgument(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return BlockPosArgument.getLoadedBlockPos(context, (String)"location");
    }

    protected static BlockPos rootPosArgument(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos rootPos;
        BlockPos pos = SubCommand.blockPosArgument(context);
        BlockState sourceState = ((CommandSourceStack)context.getSource()).getLevel().getBlockState(pos);
        Block block = sourceState.getBlock();
        if (block instanceof DynamicSaplingBlock) {
            DynamicSaplingBlock sapling = (DynamicSaplingBlock)block;
            sapling.performBonemeal(((CommandSourceStack)context.getSource()).getLevel(), ((CommandSourceStack)context.getSource()).getLevel().getRandom(), pos, sourceState);
        }
        if ((rootPos = TreeHelper.findRootNode((Level)((CommandSourceStack)context.getSource()).getLevel(), pos)) == BlockPos.ZERO) {
            throw NO_TREE_FOUND.create((Object)pos);
        }
        return rootPos;
    }

    protected static RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> speciesArgument() {
        return SubCommand.resourceLocationArgument("species", Species.REGISTRY::getRegistryNames);
    }

    protected static Species speciesArgument(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceLocation registryName = ResourceLocationArgument.getId(context, (String)"species");
        Species species = Species.findSpecies(registryName);
        if (!species.isValid()) {
            throw SPECIES_UNKNOWN.create((Object)registryName.toString());
        }
        return species;
    }

    protected static RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> resourceLocationArgument(String name, Supplier<Collection<ResourceLocation>> suggestionsSupplier) {
        return Commands.argument((String)name, (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> SharedSuggestionProvider.suggestResource((Iterable)((Iterable)suggestionsSupplier.get()), (SuggestionsBuilder)builder));
    }

    protected static Component aqua(Object object) {
        return CommandHelper.colour(object, ChatFormatting.AQUA);
    }

    protected static Component darkRed(Object object) {
        return CommandHelper.colour(object, ChatFormatting.DARK_RED);
    }

    protected static void sendSuccess(CommandSourceStack source, Component component) {
        source.sendSuccess(() -> component.copy().withStyle(style -> style.withColor(ChatFormatting.GREEN)), false);
    }

    protected static void sendSuccessAndLog(CommandSourceStack source, Component component) {
        source.sendSuccess(() -> component.copy().withStyle(style -> style.withColor(ChatFormatting.GREEN)), true);
    }

    protected static void sendFailure(CommandSourceStack source, Component component) {
        source.sendFailure((Component)component.copy().withStyle(style -> style.withColor(ChatFormatting.RED)));
    }
}

