/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.data.generator;

import com.dtteam.dynamictrees.block.branch.SurfaceRootBlock;
import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.data.builder.BranchLoaderBuilder;
import com.dtteam.dynamictrees.data.provider.DTBlockStateProvider;
import com.dtteam.dynamictrees.tree.family.Family;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class SurfaceRootStateGenerator
implements Generator<DTDataProvider.BlockState, Family> {
    public static final Generator.DependencyKey<SurfaceRootBlock> SURFACE_ROOT = new Generator.DependencyKey("surface_root");
    public static final Generator.DependencyKey<Block> PRIMITIVE_LOG = new Generator.DependencyKey("primitive_log");

    @Override
    public void generate(DTDataProvider.BlockState prov, Family input, Generator.Dependencies dependencies) {
        if (prov instanceof DTBlockStateProvider) {
            DTBlockStateProvider provider = (DTBlockStateProvider)prov;
            SurfaceRootBlock surfaceRoot = dependencies.get(SURFACE_ROOT);
            provider.simpleBlock(surfaceRoot, (ModelFile)((BranchLoaderBuilder)((BlockModelBuilder)provider.models().getBuilder(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)surfaceRoot)).getPath())).customLoader(BranchLoaderBuilder.branchBuilders.get(input.getSurfaceRootLoader()))).texture("bark", input.getTexturePath("branch").orElse(provider.block(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)dependencies.get(PRIMITIVE_LOG)))))).end());
        }
    }

    @Override
    public Generator.Dependencies gatherDependencies(Family input) {
        return new Generator.Dependencies().append(SURFACE_ROOT, input.getSurfaceRoot()).append(PRIMITIVE_LOG, input.getPrimitiveLog());
    }
}

