/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.data.provider;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.worldgen.feature.CaveRootedTreePlacement;
import com.dtteam.dynamictrees.worldgen.feature.DTReplaceNyliumFungiBlockStateProvider;
import com.dtteam.dynamictrees.worldgen.structure.VillageTreeReplacement;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Cloner;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.NetherFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NetherForestVegetationConfig;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;

public class DTDatapackBuiltinEntriesProvider
extends DatapackBuiltinEntriesProvider {
    public DTDatapackBuiltinEntriesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, Set<String> modIds) {
        super(output, (CompletableFuture)registries.thenApply(p -> DTDatapackBuiltinEntriesProvider.constructRegistries(p, DTDatapackBuiltinEntriesProvider.getBuilder(p))), modIds);
    }

    private static RegistrySetBuilder.PatchedRegistries constructRegistries(HolderLookup.Provider original, RegistrySetBuilder datapackEntriesBuilder) {
        try {
            RegistrySetBuilder.PatchedRegistries provider = datapackEntriesBuilder.buildPatch((RegistryAccess)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY), original, new Cloner.Factory());
            return provider;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static RegistrySetBuilder getBuilder(HolderLookup.Provider vanillaProvider) {
        return new RegistrySetBuilder().add(Registries.TEMPLATE_POOL, context -> DTDatapackBuiltinEntriesProvider.bootstrapTemplatePools(vanillaProvider, (BootstrapContext<StructureTemplatePool>)context)).add(Registries.CONFIGURED_FEATURE, context -> DTDatapackBuiltinEntriesProvider.bootstrapConfiguredFeatures(vanillaProvider, context)).add(Registries.PLACED_FEATURE, DTDatapackBuiltinEntriesProvider::bootstrapPlacedFeatures);
    }

    private static void bootstrapTemplatePools(HolderLookup.Provider vanillaProvider, BootstrapContext<StructureTemplatePool> context) {
        VillageTreeReplacement.replaceTreesFromVanillaVillages(vanillaProvider, context);
    }

    private static void bootstrapConfiguredFeatures(HolderLookup.Provider vanillaProvider, BootstrapContext<ConfiguredFeature<?, ?>> context) {
        context.register(DTRegistries.DYNAMIC_TREE_CONFIGURED_FEATURE, (Object)new ConfiguredFeature((Feature)DTRegistries.DYNAMIC_TREE_FEATURE.get(), (FeatureConfiguration)NoneFeatureConfiguration.INSTANCE));
        context.register(DTRegistries.CAVE_ROOTED_TREE_CONFIGURED_FEATURE, (Object)new ConfiguredFeature((Feature)DTRegistries.CAVE_ROOTED_TREE_FEATURE.get(), (FeatureConfiguration)NoneFeatureConfiguration.INSTANCE));
        DTDatapackBuiltinEntriesProvider.replaceNyliumFungiFeatures(vanillaProvider, context);
    }

    private static void bootstrapPlacedFeatures(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        context.register(DTRegistries.DYNAMIC_TREE_PLACED_FEATURE, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(DTRegistries.DYNAMIC_TREE_CONFIGURED_FEATURE), List.of()));
        context.register(DTRegistries.CAVE_ROOTED_TREE_PLACED_FEATURE, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(DTRegistries.CAVE_ROOTED_TREE_CONFIGURED_FEATURE), List.of(CaveRootedTreePlacement.INSTANCE, PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome())));
    }

    private static void replaceNyliumFungiFeatures(HolderLookup.Provider vanillaProvider, BootstrapContext<ConfiguredFeature<?, ?>> context) {
        Species.findSpecies(DynamicTrees.CRIMSON).getSapling().ifPresent(crimsonSapling -> Species.findSpecies(DynamicTrees.WARPED).getSapling().ifPresent(warpedSapling -> {
            HolderLookup.RegistryLookup configuredFeatures = (HolderLookup.RegistryLookup)vanillaProvider.lookup(Registries.CONFIGURED_FEATURE).orElseThrow();
            List.of(NetherFeatures.CRIMSON_FOREST_VEGETATION, NetherFeatures.CRIMSON_FOREST_VEGETATION_BONEMEAL, NetherFeatures.WARPED_FOREST_VEGETION, NetherFeatures.WARPED_FOREST_VEGETATION_BONEMEAL).forEach(key -> DTDatapackBuiltinEntriesProvider.replaceFeature(context, configuredFeatures, key, crimsonSapling, warpedSapling));
        }));
    }

    private static void replaceFeature(BootstrapContext<ConfiguredFeature<?, ?>> context, HolderLookup.RegistryLookup<ConfiguredFeature<?, ?>> configuredFeatures, ResourceKey<ConfiguredFeature<?, ?>> key, Block crimsonSapling, Block warpedSapling) {
        ConfiguredFeature feature = (ConfiguredFeature)configuredFeatures.getOrThrow(key).value();
        NetherForestVegetationConfig config = (NetherForestVegetationConfig)feature.config();
        WeightedStateProvider stateProvider = (WeightedStateProvider)config.stateProvider;
        NetherForestVegetationConfig newConfig = new NetherForestVegetationConfig(DTDatapackBuiltinEntriesProvider.replaceBlockStates(stateProvider, crimsonSapling, warpedSapling), config.spreadWidth, config.spreadHeight);
        context.register(key, (Object)new ConfiguredFeature(Feature.NETHER_FOREST_VEGETATION, (FeatureConfiguration)newConfig));
    }

    private static BlockStateProvider replaceBlockStates(WeightedStateProvider stateProvider, Block crimsonSapling, Block warpedSapling) {
        SimpleWeightedRandomList.Builder listBuilder = SimpleWeightedRandomList.builder();
        for (WeightedEntry.Wrapper entry : stateProvider.weightedList.unwrap()) {
            BlockState blockState = (BlockState)entry.data();
            if (blockState.is(Blocks.CRIMSON_FUNGUS)) {
                blockState = crimsonSapling.defaultBlockState();
            } else if (blockState.is(Blocks.WARPED_FUNGUS)) {
                blockState = warpedSapling.defaultBlockState();
            }
            listBuilder.add((Object)blockState, entry.getWeight().asInt());
        }
        return new DTReplaceNyliumFungiBlockStateProvider((BlockStateProvider)new WeightedStateProvider(listBuilder), (BlockStateProvider)stateProvider);
    }
}

