/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization;

import com.dtteam.dynamictrees.api.cell.CellKit;
import com.dtteam.dynamictrees.api.configuration.PropertyDefinition;
import com.dtteam.dynamictrees.api.worldgen.BiomePredicate;
import com.dtteam.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.dtteam.dynamictrees.api.worldgen.FeatureCanceller;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.fruit.Fruit;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.pod.Pod;
import com.dtteam.dynamictrees.block.soil.SoilProperties;
import com.dtteam.dynamictrees.deserialization.NoSuchDeserializerException;
import com.dtteam.dynamictrees.deserialization.deserializer.AxisAlignedBBDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.BiomeListDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.BooleanOpDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.BuiltInRegistryEntryDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.ConfiguredDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.DeserializableClassDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.EnumDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.JsonDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.ListDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.MapColorDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.MapDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.PropertyDefinitionDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.RegistryEntryDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.ResourceLocationDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.SeedSaplingRecipeDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.SoundTypeDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.VoxelShapeDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.worldgen.ChanceSelectorDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.worldgen.DensitySelectorDeserializer;
import com.dtteam.dynamictrees.deserialization.deserializer.worldgen.SpeciesSelectorDeserializer;
import com.dtteam.dynamictrees.deserialization.result.JsonResult;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.dtteam.dynamictrees.item.Seed;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.SeedSaplingRecipe;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.VinesGenFeature;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKit;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKitConfiguration;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.worldgen.BiomeDatabase;
import com.dtteam.dynamictrees.worldgen.IDTBiomeHolderSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class JsonDeserializers {
    private static final Map<Class<?>, JsonDeserializer<?>> DESERIALIZERS = Maps.newHashMap();
    public static final JsonDeserializer<?> NULL = new NullDeserializer();
    public static final JsonDeserializer<JsonElement> JSON_ELEMENT = JsonDeserializers.register(JsonElement.class, input -> JsonResult.success(input, input));
    public static final JsonDeserializer<JsonNull> JSON_NULL = JsonDeserializers.register(JsonNull.class, input -> input.isJsonNull() ? JsonResult.success(input, JsonNull.INSTANCE) : JsonResult.failure(input, "Json element was not a json null."));
    public static final JsonDeserializer<JsonPrimitive> JSON_PRIMITIVE = JsonDeserializers.register(JsonPrimitive.class, input -> input.isJsonPrimitive() ? JsonResult.success(input, input.getAsJsonPrimitive()) : JsonResult.failure(input, "Json element was not a json primitive."));
    public static final JsonDeserializer<JsonObject> JSON_OBJECT = JsonDeserializers.register(JsonObject.class, input -> input.isJsonObject() ? JsonResult.success(input, input.getAsJsonObject()) : JsonResult.failure(input, "Json element was not a json object."));
    public static final JsonDeserializer<JsonArray> JSON_ARRAY = JsonDeserializers.register(JsonArray.class, input -> input.isJsonArray() ? JsonResult.success(input, input.getAsJsonArray()) : JsonResult.failure(input, "Json element was not a json array."));
    public static final JsonDeserializer<Boolean> BOOLEAN = JsonDeserializers.register(Boolean.class, input -> JSON_PRIMITIVE.deserialize(input).mapIfValid(JsonPrimitive::isBoolean, "Could not get boolean from \"{}\".", JsonPrimitive::getAsBoolean));
    public static final JsonDeserializer<Number> NUMBER = JsonDeserializers.register(Number.class, input -> JSON_PRIMITIVE.deserialize(input).mapIfValid(JsonPrimitive::isNumber, "Could not get number from \"{}\".", JsonPrimitive::getAsNumber));
    public static final JsonDeserializer<String> STRING = JsonDeserializers.register(String.class, input -> JSON_PRIMITIVE.deserialize(input).mapIfValid(JsonPrimitive::isString, "Could not get string from \"{}\".", JsonPrimitive::getAsString));
    public static final JsonDeserializer<Byte> BYTE = JsonDeserializers.register(Byte.class, input -> NUMBER.deserialize(input).map(Number::byteValue));
    public static final JsonDeserializer<Short> SHORT = JsonDeserializers.register(Short.class, input -> NUMBER.deserialize(input).map(Number::shortValue));
    public static final JsonDeserializer<Integer> INTEGER = JsonDeserializers.register(Integer.class, input -> NUMBER.deserialize(input).map(Number::intValue));
    public static final JsonDeserializer<Long> LONG = JsonDeserializers.register(Long.class, input -> NUMBER.deserialize(input).map(Number::longValue));
    public static final JsonDeserializer<Float> FLOAT = JsonDeserializers.register(Float.class, input -> NUMBER.deserialize(input).map(Number::floatValue));
    public static final JsonDeserializer<Double> DOUBLE = JsonDeserializers.register(Double.class, input -> NUMBER.deserialize(input).map(Number::doubleValue));
    public static final JsonDeserializer<ResourceLocation> RESOURCE_LOCATION = JsonDeserializers.register(ResourceLocation.class, ResourceLocationDeserializer.create());
    public static final JsonDeserializer<ResourceLocation> DT_RESOURCE_LOCATION = ResourceLocationDeserializer.create("dynamictrees");
    public static JsonDeserializer<Block> BLOCK;
    public static JsonDeserializer<Item> ITEM;
    public static JsonDeserializer<ItemStack> ITEM_STACK;
    public static final JsonDeserializer<AABB> AABB;
    public static final JsonDeserializer<VoxelShape> VOXEL_SHAPE;
    public static final JsonDeserializer<CellKit> CELL_KIT;
    public static final JsonDeserializer<LeavesProperties> LEAVES_PROPERTIES;
    public static final JsonDeserializer<GrowthLogicKit> GROWTH_LOGIC_KIT;
    public static final JsonDeserializer<GenFeature> GEN_FEATURE;
    public static final JsonDeserializer<Family> FAMILY;
    public static final JsonDeserializer<Fruit> FRUIT;
    public static final JsonDeserializer<Pod> POD;
    public static final JsonDeserializer<Species> SPECIES;
    public static final JsonDeserializer<SoilProperties> SOIL_PROPERTIES;
    public static final JsonDeserializer<List<SoilProperties>> SOIL_PROPERTIES_LIST;
    public static final JsonDeserializer<FeatureCanceller> FEATURE_CANCELLER;
    public static final JsonDeserializer<Map<String, ResourceLocation>> RESOURCE_LOCATION_MAP;
    public static final JsonDeserializer<GenFeatureConfiguration> CONFIGURED_GEN_FEATURE;
    public static final JsonDeserializer<GrowthLogicKitConfiguration> CONFIGURED_GROWTH_LOGIC_KIT;
    public static final JsonDeserializer<Seed> SEED;
    public static final JsonDeserializer<BranchBlock> BRANCH;
    public static final JsonDeserializer<VinesGenFeature.VineType> VINE_TYPE;
    public static final JsonDeserializer<GenerationStep.Decoration> DECORATION_STAGE;
    public static final JsonDeserializer<BiomeDatabase.Operation> OPERATION;
    public static final JsonDeserializer<IDTBiomeHolderSet> BIOME_LIST;
    public static final JsonDeserializer<BiomePredicate> BIOME_PREDICATE;
    public static final JsonDeserializer<BiomePropertySelectors.SpeciesSelector> SPECIES_SELECTOR;
    public static final JsonDeserializer<BiomePropertySelectors.DensitySelector> DENSITY_SELECTOR;
    public static final JsonDeserializer<BiomePropertySelectors.ChanceSelector> CHANCE_SELECTOR;
    public static final JsonDeserializer<SeedSaplingRecipe> SEED_SAPLING_RECIPE;
    public static final JsonDeserializer<MapColor> MAP_COLOR;
    public static final JsonDeserializer<SoundType> SOUND_TYPE;
    public static final JsonDeserializer<BooleanOp> BOOLEAN_FUNCTION;
    public static final JsonDeserializer<Class<?>> DESERIALIZABLE_CLASS;
    public static final JsonDeserializer<PropertyDefinition<?>> VARIABLE_DEFINITION;

    public static <T> JsonDeserializer<T> get(Class<T> type) {
        return DESERIALIZERS.getOrDefault(type, NULL);
    }

    public static <T> JsonDeserializer<T> getOrThrow(Class<T> type) throws NoSuchDeserializerException {
        return JsonDeserializers.getOrThrow(type, "No Json deserializer found for type \"" + type.getName() + "\".");
    }

    public static <T> JsonDeserializer<T> getOrThrow(Class<T> type, String errorMessage) throws NoSuchDeserializerException {
        JsonDeserializer<?> deserializer = DESERIALIZERS.get(type);
        if (deserializer == null) {
            throw new NoSuchDeserializerException(errorMessage);
        }
        return deserializer;
    }

    public static Set<Class<?>> getDeserializableClasses() {
        return DESERIALIZERS.keySet();
    }

    public static <T> JsonDeserializer<T> register(Class<T> outputClass, JsonDeserializer<T> deserializer) {
        DESERIALIZERS.put(outputClass, deserializer);
        return deserializer;
    }

    public static void registerRegistryEntryGetters() {
        BLOCK = JsonDeserializers.register(Block.class, new BuiltInRegistryEntryDeserializer<Block>((Registry<Block>)BuiltInRegistries.BLOCK, "block", Blocks.AIR));
        ITEM = JsonDeserializers.register(Item.class, new BuiltInRegistryEntryDeserializer<Item>((Registry<Item>)BuiltInRegistries.ITEM, "item", Items.AIR));
    }

    public static void postRegistryEvent() {
        Services.EVENT.postJsonDeserializerRegistryEvent();
    }

    static {
        ITEM_STACK = JsonDeserializers.register(ItemStack.class, input -> ITEM.deserialize(input).map(ItemStack::new));
        AABB = JsonDeserializers.register(AABB.class, new AxisAlignedBBDeserializer());
        VOXEL_SHAPE = JsonDeserializers.register(VoxelShape.class, new VoxelShapeDeserializer());
        CELL_KIT = JsonDeserializers.register(CellKit.class, new RegistryEntryDeserializer<CellKit>(CellKit.REGISTRY));
        LEAVES_PROPERTIES = JsonDeserializers.register(LeavesProperties.class, new RegistryEntryDeserializer<LeavesProperties>(LeavesProperties.REGISTRY));
        GROWTH_LOGIC_KIT = JsonDeserializers.register(GrowthLogicKit.class, new RegistryEntryDeserializer(GrowthLogicKit.REGISTRY));
        GEN_FEATURE = JsonDeserializers.register(GenFeature.class, new RegistryEntryDeserializer(GenFeature.REGISTRY));
        FAMILY = JsonDeserializers.register(Family.class, new RegistryEntryDeserializer<Family>(Family.REGISTRY));
        FRUIT = JsonDeserializers.register(Fruit.class, new RegistryEntryDeserializer<Fruit>(Fruit.REGISTRY));
        POD = JsonDeserializers.register(Pod.class, new RegistryEntryDeserializer<Pod>(Pod.REGISTRY));
        SPECIES = JsonDeserializers.register(Species.class, new RegistryEntryDeserializer<Species>(Species.REGISTRY));
        SOIL_PROPERTIES = JsonDeserializers.register(SoilProperties.class, new RegistryEntryDeserializer<SoilProperties>(SoilProperties.REGISTRY));
        SOIL_PROPERTIES_LIST = JsonDeserializers.register(ListDeserializer.getListClass(SoilProperties.class), new ListDeserializer<SoilProperties>(SOIL_PROPERTIES));
        FEATURE_CANCELLER = JsonDeserializers.register(FeatureCanceller.class, new RegistryEntryDeserializer<FeatureCanceller>(FeatureCanceller.REGISTRY));
        RESOURCE_LOCATION_MAP = JsonDeserializers.register(MapDeserializer.getMapClass(String.class, ResourceLocation.class), new MapDeserializer<String, ResourceLocation>(STRING, RESOURCE_LOCATION));
        CONFIGURED_GEN_FEATURE = JsonDeserializers.register(GenFeatureConfiguration.class, new ConfiguredDeserializer<GenFeatureConfiguration, GenFeature>("Gen Feature", GenFeature.class, GenFeatureConfiguration.TEMPLATES));
        CONFIGURED_GROWTH_LOGIC_KIT = JsonDeserializers.register(GrowthLogicKitConfiguration.class, new ConfiguredDeserializer<GrowthLogicKitConfiguration, GrowthLogicKit>("Growth Logic Kit", GrowthLogicKit.class, GrowthLogicKitConfiguration.TEMPLATES));
        SEED = JsonDeserializers.register(Seed.class, jsonElement -> ITEM.deserialize(jsonElement).mapIfValid(item -> item instanceof Seed, "Item \"{}\" is not a seed.", item -> (Seed)((Object)((Object)item))));
        BRANCH = JsonDeserializers.register(BranchBlock.class, jsonElement -> BLOCK.deserialize(jsonElement).mapIfValid(block -> block instanceof BranchBlock, "Block \"{}\" is not a branch.", block -> (BranchBlock)block));
        VINE_TYPE = JsonDeserializers.register(VinesGenFeature.VineType.class, new EnumDeserializer<VinesGenFeature.VineType>(VinesGenFeature.VineType.class));
        DECORATION_STAGE = JsonDeserializers.register(GenerationStep.Decoration.class, new EnumDeserializer<GenerationStep.Decoration>(GenerationStep.Decoration.class));
        OPERATION = JsonDeserializers.register(BiomeDatabase.Operation.class, new EnumDeserializer<BiomeDatabase.Operation>(BiomeDatabase.Operation.class));
        BIOME_LIST = JsonDeserializers.register(IDTBiomeHolderSet.class, new BiomeListDeserializer());
        BIOME_PREDICATE = JsonDeserializers.register(BiomePredicate.class, jsonElement -> BIOME_LIST.deserialize(jsonElement).map(biomeList -> biome -> biomeList.stream().anyMatch(currentBiomeHolder -> {
            if (currentBiomeHolder.equals(biome)) return true;
            if (biome.unwrapKey().map(arg_0 -> ((Holder)currentBiomeHolder).is(arg_0)).orElse(false) == false) return false;
            return true;
        })));
        SPECIES_SELECTOR = JsonDeserializers.register(BiomePropertySelectors.SpeciesSelector.class, new SpeciesSelectorDeserializer());
        DENSITY_SELECTOR = JsonDeserializers.register(BiomePropertySelectors.DensitySelector.class, new DensitySelectorDeserializer());
        CHANCE_SELECTOR = JsonDeserializers.register(BiomePropertySelectors.ChanceSelector.class, new ChanceSelectorDeserializer());
        SEED_SAPLING_RECIPE = JsonDeserializers.register(SeedSaplingRecipe.class, new SeedSaplingRecipeDeserializer());
        MAP_COLOR = JsonDeserializers.register(MapColor.class, new MapColorDeserializer());
        SOUND_TYPE = JsonDeserializers.register(SoundType.class, new SoundTypeDeserializer());
        BOOLEAN_FUNCTION = JsonDeserializers.register(BooleanOp.class, new BooleanOpDeserializer());
        DESERIALIZABLE_CLASS = new DeserializableClassDeserializer();
        VARIABLE_DEFINITION = JsonDeserializers.register(PropertyDefinition.captureClass(), new PropertyDefinitionDeserializer());
    }

    private static final class NullDeserializer<O>
    implements JsonDeserializer<O> {
        private NullDeserializer() {
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public boolean deserializeIfValid(JsonElement input, Consumer<Result<O, JsonElement>> consumer) {
            return false;
        }

        @Override
        public Result<O, JsonElement> deserialize(JsonElement input) {
            return JsonResult.failure(input, "Could not get Json deserializer for json element: " + String.valueOf(input) + ".");
        }
    }
}

