/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.deserializer;

import com.dtteam.dynamictrees.deserialization.JsonMapWrapper;
import com.dtteam.dynamictrees.deserialization.JsonPropertyAppliers;
import com.dtteam.dynamictrees.deserialization.applier.Applier;
import com.dtteam.dynamictrees.deserialization.applier.PropertyApplierResult;
import com.dtteam.dynamictrees.deserialization.applier.VoidApplier;
import com.dtteam.dynamictrees.deserialization.deserializer.JsonDeserializer;
import com.dtteam.dynamictrees.deserialization.result.JsonResult;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.worldgen.IDTBiomeHolderSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BiomeListDeserializer
implements JsonDeserializer<IDTBiomeHolderSet> {
    public static final Supplier<Registry<Biome>> DELAYED_BIOME_REGISTRY = () -> {
        MinecraftServer currentServer = Services.MISC.getCurrentServer();
        if (currentServer == null) {
            throw new IllegalStateException("Queried biome registry too early; server does not exist yet!");
        }
        return currentServer.registryAccess().registryOrThrow(Registries.BIOME);
    };
    private static final Applier<IDTBiomeHolderSet, String> TAG_APPLIER = (biomeList, tagRegex) -> {
        boolean notOperator = BiomeListDeserializer.usingNotOperator(tagRegex = tagRegex.toLowerCase(Locale.ENGLISH));
        if (notOperator) {
            tagRegex = tagRegex.substring(1);
        }
        if (tagRegex.charAt(0) == '#') {
            tagRegex = tagRegex.substring(1);
        }
        try {
            ResourceLocation tagLocation = ResourceLocation.parse((String)tagRegex);
            TagKey tagKey = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)tagLocation);
            biomeList.addDelayedHolderSet(notOperator ? biomeList.getExcludeComponents() : biomeList.getIncludeComponents(), () -> DELAYED_BIOME_REGISTRY.get().getOrCreateTag(tagKey));
        }
        catch (ResourceLocationException e) {
            return PropertyApplierResult.failure(e.getMessage());
        }
        return PropertyApplierResult.success();
    };
    private static final VoidApplier<IDTBiomeHolderSet, String> NAME_APPLIER = (biomeList, nameRegex) -> {
        boolean notOperator = BiomeListDeserializer.usingNotOperator(nameRegex = nameRegex.toLowerCase(Locale.ENGLISH));
        if (notOperator) {
            nameRegex = nameRegex.substring(1);
        }
        String finalNameRegex = nameRegex;
        biomeList.addNameRegexMatch(notOperator ? biomeList.getExcludeComponents() : biomeList.getIncludeComponents(), () -> DELAYED_BIOME_REGISTRY.get().asLookup(), finalNameRegex);
    };
    private static final VoidApplier<IDTBiomeHolderSet, JsonArray> NAMES_OR_APPLIER = (biomeList, json) -> {
        List<String> nameRegexes = JsonResult.forInput((JsonElement)json).mapEachIfArray(String.class, String::toLowerCase).orElse(Collections.emptyList(), arg_0 -> ((Logger)LogManager.getLogger()).error(arg_0), arg_0 -> ((Logger)LogManager.getLogger()).warn(arg_0));
        ArrayList<HolderSet<Biome>> orIncludes = new ArrayList<HolderSet<Biome>>();
        ArrayList<HolderSet<Biome>> orExcludes = new ArrayList<HolderSet<Biome>>();
        nameRegexes.forEach(nameRegex -> {
            boolean notOperator = BiomeListDeserializer.usingNotOperator(nameRegex = nameRegex.toLowerCase(Locale.ENGLISH));
            if (notOperator) {
                nameRegex = nameRegex.substring(1);
            }
            String finalNameRegex = nameRegex;
            biomeList.addNameRegexMatch(notOperator ? orExcludes : orIncludes, () -> DELAYED_BIOME_REGISTRY.get().asLookup(), finalNameRegex);
        });
        if (!orIncludes.isEmpty()) {
            biomeList.addOr(biomeList.getIncludeComponents(), orIncludes);
        }
        if (!orExcludes.isEmpty()) {
            biomeList.addOr(biomeList.getExcludeComponents(), orExcludes);
        }
    };
    private static final VoidApplier<IDTBiomeHolderSet, JsonArray> TAGS_OR_APPLIER = (biomeList, json) -> {
        List<String> nameRegexes = JsonResult.forInput((JsonElement)json).mapEachIfArray(String.class, String::toLowerCase).orElse(Collections.emptyList(), arg_0 -> ((Logger)LogManager.getLogger()).error(arg_0), arg_0 -> ((Logger)LogManager.getLogger()).warn(arg_0));
        ArrayList<HolderSet<Biome>> orIncludes = new ArrayList<HolderSet<Biome>>();
        ArrayList<HolderSet<Biome>> orExcludes = new ArrayList<HolderSet<Biome>>();
        nameRegexes.forEach(tagRegex -> {
            boolean notOperator = BiomeListDeserializer.usingNotOperator(tagRegex = tagRegex.toLowerCase(Locale.ENGLISH));
            if (notOperator) {
                tagRegex = tagRegex.substring(1);
            }
            if (tagRegex.charAt(0) == '#') {
                tagRegex = tagRegex.substring(1);
            }
            biomeList.addTagsRegexMatch(notOperator ? orExcludes : orIncludes, () -> DELAYED_BIOME_REGISTRY.get().asLookup(), (String)tagRegex);
        });
        if (!orIncludes.isEmpty()) {
            biomeList.addOr(biomeList.getIncludeComponents(), orIncludes);
        }
        if (!orExcludes.isEmpty()) {
            biomeList.addOr(biomeList.getExcludeComponents(), orExcludes);
        }
    };
    private final VoidApplier<IDTBiomeHolderSet, JsonObject> andOperator = (biomes, jsonObject) -> this.applyAllAppliers((JsonObject)jsonObject, (IDTBiomeHolderSet)biomes);
    private final VoidApplier<IDTBiomeHolderSet, JsonArray> orOperator = (biomeList, json) -> {
        LinkedList<HolderSet<Biome>> appliedList = new LinkedList<HolderSet<Biome>>();
        JsonResult.forInput((JsonElement)json).mapEachIfArray(JsonObject.class, object -> {
            IDTBiomeHolderSet subList = Services.MISC.newDTBiomeHolderSet();
            this.applyAllAppliers((JsonObject)object, subList);
            appliedList.add(subList);
            return object;
        }).orElse(null, arg_0 -> ((Logger)LogManager.getLogger()).error(arg_0), arg_0 -> ((Logger)LogManager.getLogger()).warn(arg_0));
        if (!appliedList.isEmpty()) {
            biomeList.addOr(biomeList.getIncludeComponents(), appliedList);
        }
    };
    private final VoidApplier<IDTBiomeHolderSet, JsonObject> notOperator = (biomeList, jsonObject) -> {
        IDTBiomeHolderSet notBiomeList = Services.MISC.newDTBiomeHolderSet();
        this.applyAllAppliers((JsonObject)jsonObject, notBiomeList);
        biomeList.getExcludeComponents().add(notBiomeList);
    };
    private final JsonPropertyAppliers<IDTBiomeHolderSet> appliers = new JsonPropertyAppliers<IDTBiomeHolderSet>(IDTBiomeHolderSet.class);

    private static boolean usingNotOperator(String categoryString) {
        return categoryString.charAt(0) == '!';
    }

    public BiomeListDeserializer() {
        this.registerAppliers();
    }

    private void registerAppliers() {
        ((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)this.appliers.register("tag", (Class)String.class, TAG_APPLIER)).registerArrayApplier("tags", (Class)String.class, (Applier)TAG_APPLIER)).register("tags_or", (Class)JsonArray.class, (VoidApplier)TAGS_OR_APPLIER)).register("name", (Class)String.class, (VoidApplier)NAME_APPLIER)).registerArrayApplier("names", (Class)String.class, (VoidApplier)NAME_APPLIER)).register("names_or", (Class)JsonArray.class, (VoidApplier)NAMES_OR_APPLIER)).registerArrayApplier("AND", (Class)JsonObject.class, (VoidApplier)this.andOperator)).register("OR", (Class)JsonArray.class, (VoidApplier)this.orOperator)).register("NOT", (Class)JsonObject.class, (VoidApplier)this.notOperator);
    }

    private void applyAllAppliers(JsonObject json, IDTBiomeHolderSet biomes) {
        this.appliers.applyAll(new JsonMapWrapper(json), biomes);
    }

    @Override
    public Result<IDTBiomeHolderSet, JsonElement> deserialize(JsonElement input) {
        return JsonResult.forInput(input).mapIfType(String.class, biomeName -> {
            IDTBiomeHolderSet biomes = Services.MISC.newDTBiomeHolderSet();
            biomes.addNameRegexMatch(biomes.getIncludeComponents(), () -> DELAYED_BIOME_REGISTRY.get().asLookup(), biomeName.toLowerCase(Locale.ENGLISH));
            return biomes;
        }).elseMapIfType(JsonObject.class, selectorObject -> {
            IDTBiomeHolderSet biomes = Services.MISC.newDTBiomeHolderSet();
            this.applyAllAppliers((JsonObject)selectorObject, biomes);
            return biomes;
        }).elseTypeError();
    }
}

