/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.deserializer;

import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.deserializer.JsonDeserializer;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class MapDeserializer<K, V>
implements JsonDeserializer<Map<K, V>> {
    private final JsonDeserializer<K> keyGetter;
    private final JsonDeserializer<V> valueGetter;
    private final Supplier<Map<K, V>> mapSupplier;

    public MapDeserializer(JsonDeserializer<K> keyGetter, JsonDeserializer<V> valueGetter) {
        this(keyGetter, valueGetter, HashMap::new);
    }

    public MapDeserializer(JsonDeserializer<K> keyGetter, JsonDeserializer<V> valueGetter, Supplier<Map<K, V>> mapSupplier) {
        this.keyGetter = keyGetter;
        this.valueGetter = valueGetter;
        this.mapSupplier = mapSupplier;
    }

    @Override
    public Result<Map<K, V>, JsonElement> deserialize(JsonElement jsonElement) {
        return JsonDeserializers.JSON_OBJECT.deserialize(jsonElement).map((object, warningConsumer) -> {
            Map map = this.mapSupplier.get();
            for (Map.Entry entry : object.entrySet()) {
                this.valueGetter.deserialize((JsonElement)entry.getValue()).map(value -> this.keyGetter.deserialize(new JsonPrimitive((String)entry.getKey())).ifSuccessOrElseThrow(key -> map.put(key, value), (Consumer<String>)warningConsumer)).orElseThrow();
            }
            return map;
        });
    }

    public static <K, V> Class<Map<K, V>> getMapClass(Class<K> keyClass, Class<V> valueClass) {
        return MapDeserializer.getMapClass(keyClass, valueClass, HashMap::new);
    }

    public static <K, V> Class<Map<K, V>> getMapClass(Class<K> keyClass, Class<V> valueClass, Supplier<Map<K, V>> mapSupplier) {
        return mapSupplier.get().getClass();
    }
}

