/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.deserializer;

import com.dtteam.dynamictrees.api.configuration.PropertyDefinition;
import com.dtteam.dynamictrees.deserialization.DeserializationException;
import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.deserializer.JsonDeserializer;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;

public final class PropertyDefinitionDeserializer
implements JsonDeserializer<PropertyDefinition<?>> {
    @Override
    public Result<PropertyDefinition<?>, JsonElement> deserialize(JsonElement input) {
        return JsonDeserializers.JSON_OBJECT.deserialize(input).map(this::deserializeDefinition);
    }

    private <T> PropertyDefinition<T> deserializeDefinition(JsonObject object, Consumer<String> warningAppender) throws DeserializationException {
        String key = object.get("key").getAsString();
        Class type = (Class)JsonDeserializers.DESERIALIZABLE_CLASS.deserialize(object.get("type")).forEachWarning(warningAppender).orElseThrow();
        Object defaultValue = JsonDeserializers.get(type).deserialize(object.get("default")).forEachWarning(warningAppender).orElse(null);
        return new PropertyDefinition<Object>(key, type, defaultValue);
    }
}

