/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.deserializer.worldgen;

import com.dtteam.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.dtteam.dynamictrees.deserialization.DeserializationException;
import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.JsonMath;
import com.dtteam.dynamictrees.deserialization.deserializer.worldgen.JsonBiomeDatabaseDeserializer;
import com.dtteam.dynamictrees.deserialization.result.JsonResult;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public final class DensitySelectorDeserializer
implements JsonBiomeDatabaseDeserializer<BiomePropertySelectors.DensitySelector> {
    @Override
    public Result<BiomePropertySelectors.DensitySelector, JsonElement> deserialize(JsonElement input) {
        return JsonResult.forInput(input).mapIfType(JsonObject.class, this::readDensitySelector).elseMapIfType(JsonArray.class, this::createScaleDensitySelector).elseMapIfType(Float.class, this::createStaticDensitySelector).elseTypeError();
    }

    private BiomePropertySelectors.DensitySelector createStaticDensitySelector(float density) {
        return (rnd, n) -> density;
    }

    private BiomePropertySelectors.DensitySelector createScaleDensitySelector(JsonArray jsonArray, Consumer<String> warningConsumer) {
        ArrayList parameters = new ArrayList();
        for (JsonElement element : jsonArray) {
            JsonDeserializers.FLOAT.deserialize(element).ifSuccessOrElse(parameters::add, warningConsumer, warningConsumer);
        }
        return switch (parameters.size()) {
            case 0 -> (rnd, n) -> n;
            case 1 -> (rnd, n) -> n * (double)((Float)parameters.getFirst()).floatValue();
            case 2 -> (rnd, n) -> n * (double)((Float)parameters.getFirst()).floatValue() + (double)((Float)parameters.get(1)).floatValue();
            case 3 -> (rnd, n) -> (n * (double)((Float)parameters.getFirst()).floatValue() + (double)((Float)parameters.get(1)).floatValue()) * (double)((Float)parameters.get(2)).floatValue();
            default -> (rnd, n) -> 0.0;
        };
    }

    @Nullable
    private BiomePropertySelectors.DensitySelector readDensitySelector(JsonObject jsonObject, Consumer<String> warningConsumer) throws DeserializationException {
        return (BiomePropertySelectors.DensitySelector)JsonResult.forInput((JsonElement)jsonObject).mapIfContains("scale", JsonArray.class, this::createScaleDensitySelector).elseMapIfContains("static", Float.class, this::createStaticDensitySelector).elseMapIfContains("math", JsonElement.class, input -> {
            JsonMath jsonMath = new JsonMath((JsonElement)input);
            return (rnd, n) -> jsonMath.apply(rnd, (float)n);
        }).elseTypeError().forEachWarning(warningConsumer).orElseThrow();
    }
}

