/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.entity;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.network.BranchDestructionData;
import com.dtteam.dynamictrees.api.voxmap.BlockPosBounds;
import com.dtteam.dynamictrees.block.branch.TrunkShellBlock;
import com.dtteam.dynamictrees.entity.animation.AnimationHandler;
import com.dtteam.dynamictrees.entity.animation.AnimationHandlers;
import com.dtteam.dynamictrees.entity.animation.DataAnimationHandler;
import com.dtteam.dynamictrees.model.FallingTreeEntityModelTrackerCache;
import com.dtteam.dynamictrees.model.ModelTracker;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.CoordUtils;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FallingTreeEntity
extends Entity
implements ModelTracker {
    public static final EntityDataAccessor<CompoundTag> voxelDataParameter = SynchedEntityData.defineId(FallingTreeEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    protected List<ItemStack> payload = new ArrayList<ItemStack>(0);
    protected float volume = 0.0f;
    protected boolean hasLeaves = false;
    protected BranchDestructionData destroyData = new BranchDestructionData();
    protected Vec3 geomCenter = Vec3.ZERO;
    protected Vec3 massCenter = Vec3.ZERO;
    protected AABB normalBB = new AABB(BlockPos.ZERO);
    protected AABB cullingNormalBB = new AABB(BlockPos.ZERO);
    protected boolean clientBuilt = false;
    protected boolean firstUpdate = true;
    public boolean landed = false;
    public DestroyType destroyType = DestroyType.HARVEST;
    public boolean onFire = false;
    protected AABB cullingBB;
    protected Species species;
    public static AnimationHandler AnimHandlerFall = AnimationHandlers.falloverAnimationHandler;
    public static AnimationHandler AnimHandlerDrop = AnimationHandlers.defaultAnimationHandler;
    public static AnimationHandler AnimHandlerBurn = AnimationHandlers.defaultAnimationHandler;
    public static AnimationHandler AnimHandlerFling = AnimationHandlers.defaultAnimationHandler;
    public static AnimationHandler AnimHandlerBlast = AnimationHandlers.blastAnimationHandler;
    public AnimationHandler currentAnimationHandler = AnimationHandlers.voidAnimationHandler;
    public DataAnimationHandler dataAnimationHandler = null;

    public FallingTreeEntity(EntityType<? extends FallingTreeEntity> type, Level level) {
        super(type, level);
    }

    public boolean isClientBuilt() {
        return this.clientBuilt;
    }

    public FallingTreeEntity setData(BranchDestructionData destroyData, List<ItemStack> payload, DestroyType destroyType) {
        this.destroyData = destroyData;
        if (destroyData.getNumBranches() == 0) {
            DynamicTrees.LOG.error("Warning: Tried to create a EntityFallingTree with no branch blocks. This shouldn't be possible.");
            new Exception().printStackTrace();
            this.kill();
            return this;
        }
        BlockPos basePos = destroyData.basePos;
        this.payload = payload;
        this.destroyType = destroyType;
        this.onFire = destroyType == DestroyType.FIRE;
        this.volume = destroyData.woodVolume.getVolume();
        this.hasLeaves = destroyData.getNumLeaves() > 0;
        this.species = destroyData.species;
        this.setPosRaw((double)basePos.getX() + 0.5, basePos.getY(), (double)basePos.getZ() + 0.5);
        int numBlocks = destroyData.getNumBranches();
        this.geomCenter = new Vec3(0.0, 0.0, 0.0);
        double totalMass = 0.0;
        for (int index = 0; index < destroyData.getNumBranches(); ++index) {
            BlockPos relPos = destroyData.getBranchRelPos(index);
            int radius = destroyData.getBranchRadius(index);
            float mass = (float)(radius * radius * 64) / 4096.0f;
            totalMass += (double)mass;
            Vec3 relVec = new Vec3((double)relPos.getX(), (double)relPos.getY(), (double)relPos.getZ());
            this.geomCenter = this.geomCenter.add(relVec);
            this.massCenter = this.massCenter.add(relVec.scale((double)mass));
        }
        this.geomCenter = this.geomCenter.scale(1.0 / (double)numBlocks);
        this.massCenter = this.massCenter.scale(1.0 / totalMass);
        this.setVoxelData(this.buildVoxelData(destroyData));
        return this;
    }

    public CompoundTag buildVoxelData(BranchDestructionData destroyData) {
        CompoundTag tag = destroyData.writeToNBT(new CompoundTag());
        tag.putDouble("geomx", this.geomCenter.x);
        tag.putDouble("geomy", this.geomCenter.y);
        tag.putDouble("geomz", this.geomCenter.z);
        tag.putDouble("massx", this.massCenter.x);
        tag.putDouble("massy", this.massCenter.y);
        tag.putDouble("massz", this.massCenter.z);
        tag.putInt("destroytype", this.destroyType.ordinal());
        tag.putBoolean("onfire", this.onFire);
        tag.putFloat("volume", this.volume);
        tag.putBoolean("hasleaves", this.hasLeaves);
        tag.putString("species", this.species.getRegistryName().toString());
        return tag;
    }

    public void setupFromNBT(CompoundTag tag) {
        this.destroyData = new BranchDestructionData(tag);
        if (this.destroyData.getNumBranches() == 0) {
            this.kill();
        }
        this.destroyType = DestroyType.values()[tag.getInt("destroytype")];
        this.geomCenter = new Vec3(tag.getDouble("geomx"), tag.getDouble("geomy"), tag.getDouble("geomz"));
        this.massCenter = new Vec3(tag.getDouble("massx"), tag.getDouble("massy"), tag.getDouble("massz"));
        this.setBoundingBox(this.buildAABBFromDestroyData(this.destroyData).move(this.getX(), this.getY(), this.getZ()));
        this.cullingBB = this.cullingNormalBB.move(this.getX(), this.getY(), this.getZ());
        this.volume = tag.getFloat("volume");
        this.hasLeaves = tag.getBoolean("hasleaves");
        this.species = (Species)Species.REGISTRY.get(tag.getString("species"));
        this.onFire = tag.getBoolean("onfire");
    }

    public void buildClient() {
        CompoundTag tag = this.getVoxelData();
        if (tag.contains("species")) {
            this.setupFromNBT(tag);
            this.clientBuilt = true;
        } else {
            System.out.println("Error: No species tag has been set");
        }
        BlockPosBounds renderBounds = new BlockPosBounds(this.destroyData.cutPos);
        this.cleanupShellBlocks(this.destroyData);
        Minecraft.getInstance().levelRenderer.setBlocksDirty(renderBounds.getMin().getX(), renderBounds.getMin().getY(), renderBounds.getMin().getZ(), renderBounds.getMax().getX(), renderBounds.getMax().getY(), renderBounds.getMax().getZ());
    }

    protected void cleanupShellBlocks(BranchDestructionData destroyData) {
        BlockPos cutPos = destroyData.cutPos;
        for (int i = 0; i < destroyData.getNumBranches(); ++i) {
            if (destroyData.getBranchRadius(i) <= 8) continue;
            BlockPos pos = destroyData.getBranchRelPos(i).offset((Vec3i)cutPos);
            for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
                BlockPos dPos = pos.offset(dir.getOffset());
                if (!(this.level().getBlockState(dPos).getBlock() instanceof TrunkShellBlock)) continue;
                this.level().removeBlock(dPos, false);
            }
        }
    }

    public AABB buildAABBFromDestroyData(BranchDestructionData destroyData) {
        this.normalBB = new AABB(BlockPos.ZERO);
        for (BlockPos relPos : destroyData.getPositions(BranchDestructionData.PosType.BRANCHES, false)) {
            this.normalBB = this.normalBB.minmax(new AABB(relPos));
        }
        if (destroyData.species.leavesAreSolid()) {
            for (BlockPos relPos : destroyData.getPositions(BranchDestructionData.PosType.LEAVES, false)) {
                this.normalBB = this.normalBB.minmax(new AABB(relPos));
            }
        }
        double height = this.normalBB.maxY - this.normalBB.minY;
        double width = Mth.absMax((double)(this.normalBB.maxX - this.normalBB.minX), (double)(this.normalBB.maxZ - this.normalBB.minZ));
        double grow = Math.max(0.0, height - width / 2.0) + 2.0;
        this.cullingNormalBB = this.normalBB.inflate(grow + 4.0, 4.0, grow + 4.0);
        return this.normalBB;
    }

    public AABB getBoundingBoxForCulling() {
        return this.cullingBB;
    }

    public BranchDestructionData getDestroyData() {
        return this.destroyData;
    }

    public List<ItemStack> getPayload() {
        return this.payload;
    }

    public Vec3 getGeomCenter() {
        return this.geomCenter;
    }

    public Vec3 getMassCenter() {
        return this.massCenter;
    }

    public float getVolume() {
        return this.volume;
    }

    public boolean hasLeaves() {
        return this.hasLeaves;
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setPos(double x, double y, double z) {
        this.setPosRaw(x, y, z);
        this.setBoundingBox(this.normalBB != null ? this.normalBB.move(x, y, z) : new AABB(BlockPos.ZERO));
        this.cullingBB = this.cullingNormalBB != null ? this.cullingNormalBB.move(x, y, z) : new AABB(BlockPos.ZERO);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && !this.clientBuilt) {
            this.buildClient();
            if (!this.isAlive()) {
                return;
            }
        }
        if (!this.level().isClientSide && this.firstUpdate) {
            this.updateNeighbors();
        }
        this.handleMotion();
        this.setBoundingBox(this.normalBB.move(this.getX(), this.getY(), this.getZ()));
        this.cullingBB = this.cullingNormalBB.move(this.getX(), this.getY(), this.getZ());
        if (this.shouldDie()) {
            this.dropPayLoad();
            this.kill();
            this.modelCleanup();
        }
        this.firstUpdate = false;
    }

    protected void updateNeighbors() {
        HashSet destroyed = new HashSet();
        HashSet<BlockPos> toUpdate = new HashSet<BlockPos>();
        Iterables.concat(this.destroyData.getPositions(BranchDestructionData.PosType.BRANCHES), this.destroyData.getPositions(BranchDestructionData.PosType.LEAVES)).forEach(destroyed::add);
        for (BlockPos d : destroyed) {
            for (Direction dir : Direction.values()) {
                BlockPos dPos = d.relative(dir);
                if (destroyed.contains(dPos)) continue;
                toUpdate.add(dPos);
            }
        }
        toUpdate.forEach(pos -> this.level().neighborChanged(pos, Blocks.AIR, pos));
    }

    protected AnimationHandler selectAnimationHandler() {
        return Services.CONFIG.getBoolConfig("enableFallingTrees") != false ? this.destroyData.species.selectAnimationHandler(this) : AnimationHandlers.voidAnimationHandler;
    }

    public AnimationHandler defaultAnimationHandler() {
        if (this.destroyType == DestroyType.VOID || this.destroyType == DestroyType.ROOT) {
            return AnimationHandlers.voidAnimationHandler;
        }
        if (this.destroyType == DestroyType.EXPLODE) {
            return AnimHandlerBlast;
        }
        if (this.destroyType == DestroyType.FIRE) {
            return AnimHandlerBurn;
        }
        if (this.getDestroyData().cutDir == Direction.DOWN) {
            if (this.getMassCenter().y >= 1.0) {
                return AnimHandlerFall;
            }
            return AnimHandlerFling;
        }
        return AnimHandlerDrop;
    }

    @Override
    public void modelCleanup() {
        if (this.level().isClientSide()) {
            FallingTreeEntityModelTrackerCache.cleanupModels(this.level(), this);
        }
    }

    public void handleMotion() {
        if (this.firstUpdate) {
            this.currentAnimationHandler = this.selectAnimationHandler();
            this.currentAnimationHandler.initMotion(this);
        } else {
            this.currentAnimationHandler.handleMotion(this);
        }
    }

    public void dropPayLoad() {
        if (!this.level().isClientSide) {
            this.currentAnimationHandler.dropPayload(this);
        }
    }

    public boolean shouldDie() {
        return this.tickCount > 20 && this.currentAnimationHandler.shouldDie(this);
    }

    public boolean shouldRender(double x, double y, double z) {
        return this.currentAnimationHandler.shouldRender(this, x, y, z);
    }

    public static void standardDropLogsPayload(FallingTreeEntity entity) {
        Level level = entity.level();
        if (!level.isClientSide) {
            BlockPos cutPos = entity.getDestroyData().cutPos;
            entity.getPayload().forEach(i -> FallingTreeEntity.spawnItemAsEntity(level, cutPos, i));
        }
    }

    public static void standardDropLeavesPayLoad(FallingTreeEntity entity) {
        Level level = entity.level();
        if (!level.isClientSide) {
            BlockPos cutPos = entity.getDestroyData().cutPos;
            entity.getDestroyData().leavesDrops.forEach(bis -> Block.popResource((Level)level, (BlockPos)cutPos.offset((Vec3i)bis.pos), (ItemStack)bis.stack));
        }
    }

    public static void spawnItemAsEntity(Level level, BlockPos pos, ItemStack stack) {
        if (!level.isClientSide && !stack.isEmpty() && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && !Services.MISC.isLevelRestoringBlockSnapshots(level)) {
            ItemEntity entityitem = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack);
            entityitem.setDeltaMovement(0.0, 0.0, 0.0);
            entityitem.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)entityitem);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(voxelDataParameter, (Object)new CompoundTag());
    }

    public void setVoxelData(CompoundTag tag) {
        this.setBoundingBox(this.buildAABBFromDestroyData(this.destroyData).move(this.getX(), this.getY(), this.getZ()));
        this.cullingBB = this.cullingNormalBB.move(this.getX(), this.getY(), this.getZ());
        this.getEntityData().set(voxelDataParameter, (Object)tag);
    }

    public CompoundTag getVoxelData() {
        return (CompoundTag)this.getEntityData().get(voxelDataParameter);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        CompoundTag vox = (CompoundTag)compound.get("vox");
        this.setupFromNBT(vox);
        this.setVoxelData(vox);
        if (compound.contains("payload")) {
            ListTag nbtList = (ListTag)compound.get("payload");
            for (Tag tag : Objects.requireNonNull(nbtList)) {
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag compTag = (CompoundTag)tag;
                ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)compTag).ifPresent(t -> this.payload.add((ItemStack)t));
            }
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.put("vox", (Tag)this.getVoxelData());
        if (!this.payload.isEmpty()) {
            ListTag list = new ListTag();
            for (ItemStack stack : this.payload) {
                list.add((Object)stack.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)compound));
            }
            compound.put("payload", (Tag)list);
        }
    }

    public static FallingTreeEntity dropTree(Level level, BranchDestructionData destroyData, List<ItemStack> woodDropList, DestroyType destroyType) {
        if (!level.isClientSide()) {
            FallingTreeEntity entity = (FallingTreeEntity)DTRegistries.FALLING_TREE.get().create(level);
            if (entity == null) {
                return null;
            }
            entity.setData(destroyData, woodDropList, destroyType);
            if (entity.isAlive()) {
                level.addFreshEntity((Entity)entity);
            }
            return entity;
        }
        return null;
    }

    public static enum DestroyType {
        VOID,
        HARVEST,
        EXPLODE,
        FIRE,
        ROOT;

    }
}

