/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.entity.animation;

import com.dtteam.dynamictrees.entity.FallingTreeEntity;
import com.dtteam.dynamictrees.entity.animation.AnimationHandler;
import com.dtteam.dynamictrees.entity.animation.FalloverAnimationHandler;
import com.dtteam.dynamictrees.entity.animation.PhysicsAnimationHandler;
import com.dtteam.dynamictrees.entity.animation.VoidAnimationHandler;
import net.minecraft.core.Direction;

public class AnimationHandlers {
    public static final AnimationHandler voidAnimationHandler = new VoidAnimationHandler();
    public static final AnimationHandler defaultAnimationHandler = new PhysicsAnimationHandler(){

        @Override
        public String getName() {
            return "default";
        }

        @Override
        public void initMotion(FallingTreeEntity entity) {
            super.initMotion(entity);
            Direction cutDir = entity.getDestroyData().cutDir;
            entity.push((double)cutDir.getOpposite().getStepX() * 0.1, (double)cutDir.getOpposite().getStepY() * 0.1, (double)cutDir.getOpposite().getStepZ() * 0.1);
        }
    };
    public static final AnimationHandler blastAnimationHandler = new PhysicsAnimationHandler(){

        @Override
        public String getName() {
            return "blast";
        }

        @Override
        public void initMotion(FallingTreeEntity entity) {
            super.initMotion(entity);
        }

        @Override
        public boolean shouldDie(FallingTreeEntity entity) {
            return entity.landed || entity.tickCount > 200;
        }
    };
    public static final AnimationHandler falloverAnimationHandler = new FalloverAnimationHandler();
}

