/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.event.handler;

import com.dtteam.dynamictrees.block.sapling.DynamicSaplingBlock;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;

public class VanillaSaplingEventHandler {
    @SubscribeEvent
    public void onPlayerPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Level level;
        Block block;
        block6: {
            block5: {
                block = event.getPlacedBlock().getBlock();
                LevelAccessor levelAccessor = event.getLevel();
                if (!(levelAccessor instanceof Level)) break block5;
                level = (Level)levelAccessor;
                if (DynamicSaplingBlock.SAPLING_REPLACERS.containsKey(block)) break block6;
            }
            return;
        }
        if (event.getBlockSnapshot().getState().getBlock() == event.getBlockSnapshot().getCurrentState().getBlock()) {
            return;
        }
        BlockPos pos = event.getPos();
        Species targetSpecies = DynamicSaplingBlock.SAPLING_REPLACERS.get(block);
        Species species = targetSpecies.selfOrLocationOverride((BlockGetter)level, pos);
        level.removeBlock(pos, false);
        if (!species.plantSapling((LevelAccessor)level, pos, targetSpecies != species)) {
            ItemUtils.spawnItemStack(level, pos, species.getSeedStack(1));
        }
    }

    @SubscribeEvent
    public void onSaplingGrowTree(BlockGrowFeatureEvent event) {
        Level level;
        Block block;
        BlockPos pos;
        block5: {
            block4: {
                LevelAccessor levelAccess = event.getLevel();
                pos = event.getPos();
                block = levelAccess.getBlockState(pos).getBlock();
                if (!(levelAccess instanceof Level)) break block4;
                level = (Level)levelAccess;
                if (DynamicSaplingBlock.SAPLING_REPLACERS.containsKey(block)) break block5;
            }
            return;
        }
        Species species = DynamicSaplingBlock.SAPLING_REPLACERS.get(block).selfOrLocationOverride((BlockGetter)level, pos);
        level.removeBlock(pos, false);
        event.setCanceled(true);
        if (species.isValid() && DynamicSaplingBlock.canSaplingStay((LevelReader)level, species, pos)) {
            species.transitionToTree(level, pos);
        }
    }
}

