/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.loot;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.loot.DTLootContextParams;
import java.util.function.Consumer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public final class DTLootParameterSets {
    public static final LootContextParamSet LEAVES = DTLootParameterSets.register("leaves", builder -> builder.required(LootContextParams.BLOCK_STATE).required(DTLootContextParams.SPECIES).required(DTLootContextParams.SEASONAL_SEED_DROP_FACTOR).required(LootContextParams.TOOL).optional(LootContextParams.EXPLOSION_RADIUS));
    public static final LootContextParamSet VOLUNTARY = DTLootParameterSets.register("voluntary", builder -> builder.required(LootContextParams.BLOCK_STATE).required(DTLootContextParams.SEASONAL_SEED_DROP_FACTOR).required(DTLootContextParams.FERTILITY));
    public static final LootContextParamSet BRANCHES = DTLootParameterSets.register("branches", builder -> builder.required(LootContextParams.TOOL).required(DTLootContextParams.SPECIES).required(DTLootContextParams.VOLUME).optional(LootContextParams.EXPLOSION_RADIUS));

    private static LootContextParamSet register(String path, Consumer<LootContextParamSet.Builder> builderConsumer) {
        LootContextParamSet.Builder builder = new LootContextParamSet.Builder();
        builderConsumer.accept(builder);
        LootContextParamSet paramSet = builder.build();
        LootContextParamSets.REGISTRY.put((Object)DynamicTrees.location(path), (Object)paramSet);
        return paramSet;
    }

    public static void load() {
    }
}

