/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.loot.condition;

import com.dtteam.dynamictrees.loot.DTLootContextParams;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public final class VoluntarySeedDropChance
implements LootItemCondition {
    public static final MapCodec<VoluntarySeedDropChance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("rarity").forGetter(c -> Float.valueOf(c.rarity))).apply((Applicative)instance, VoluntarySeedDropChance::new));
    private final float rarity;

    public VoluntarySeedDropChance(float rarity) {
        this.rarity = rarity;
    }

    public LootItemConditionType getType() {
        return DTRegistries.VOLUNTARY_SEED_DROP_CHANCE.get();
    }

    public boolean test(LootContext context) {
        Float seasonalSeedDropFactor = (Float)context.getParamOrNull(DTLootContextParams.SEASONAL_SEED_DROP_FACTOR);
        assert (seasonalSeedDropFactor != null);
        return (double)this.rarity * Services.CONFIG.getDoubleConfig("voluntarySeedDropRate") * (double)seasonalSeedDropFactor.floatValue() > (double)context.getRandom().nextFloat();
    }

    public static LootItemCondition.Builder voluntarySeedDropChance() {
        return () -> new VoluntarySeedDropChance(1.0f);
    }

    public static LootItemCondition.Builder voluntarySeedDropChance(float rarity) {
        return () -> new VoluntarySeedDropChance(rarity);
    }
}

