/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.loot.function;

import com.dtteam.dynamictrees.loot.DTLootContextParams;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public final class MultiplyBySticksCount
extends LootItemConditionalFunction {
    public static final MapCodec<MultiplyBySticksCount> CODEC = RecordCodecBuilder.mapCodec(instance -> MultiplyBySticksCount.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, MultiplyBySticksCount::new));

    public MultiplyBySticksCount(List<LootItemCondition> conditions) {
        super(conditions);
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return DTRegistries.MULTIPLY_STICKS_COUNT.get();
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        Integer volume = (Integer)context.getParamOrNull(DTLootContextParams.VOLUME);
        assert (volume != null);
        stack.setCount(stack.getCount() * 8 * (volume % 4096) / 4096);
        return stack;
    }

    public static LootItemFunction.Builder multiplyBySticksCount() {
        return () -> new MultiplyBySticksCount(List.of());
    }
}

