/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.model;

import com.dtteam.dynamictrees.entity.FallingTreeEntity;
import com.dtteam.dynamictrees.model.FallingTreeEntityModel;
import com.dtteam.dynamictrees.platform.Services;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FallingTreeEntityModelTrackerCache {
    private static ConcurrentMap<Integer, FallingTreeEntityModel> models = new ConcurrentHashMap<Integer, FallingTreeEntityModel>();

    @Nullable
    public static FallingTreeEntityModel getOrCreateModel(FallingTreeEntity entity) {
        if (entity.level().isClientSide()) {
            return models.computeIfAbsent(entity.getId(), i -> Services.MISC.newFallingTreeEntityModel(entity));
        }
        return null;
    }

    public static void cleanupModels(Level level, FallingTreeEntity entity) {
        if (level.isClientSide()) {
            models.remove(entity.getId());
            FallingTreeEntityModelTrackerCache.cleanupModels(level);
        }
    }

    public static void cleanupModels(Level level) {
        models = models.entrySet().stream().filter(map -> level.getEntity(((Integer)map.getKey()).intValue()) != null).collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

