/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.model.baked;

import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.model.ModelHelper;
import com.dtteam.dynamictrees.model.modeldata.ModelConnections;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.NamedRenderTypeManager;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.IModelBuilder;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class BasicBranchBlockBakedModel
implements IDynamicBakedModel {
    protected final BlockModel blockModel;
    protected final TextureAtlasSprite barkTexture;
    protected final TextureAtlasSprite ringsTexture;
    protected final BakedModel[][] sleeves = new BakedModel[6][7];
    protected final BakedModel[][] cores = new BakedModel[3][8];
    protected final BakedModel[] rings = new BakedModel[8];

    public BasicBranchBlockBakedModel(IGeometryBakingContext customData, ResourceLocation barkTextureLocation, ResourceLocation ringsTextureLocation, Function<Material, TextureAtlasSprite> spriteGetter) {
        this.blockModel = new BlockModel(null, new ArrayList(), new HashMap(), Boolean.valueOf(false), BlockModel.GuiLight.FRONT, ItemTransforms.NO_TRANSFORMS, new ArrayList());
        this.blockModel.customData.setRenderTypeHint(customData.getRenderTypeHint());
        this.barkTexture = spriteGetter.apply(new Material(InventoryMenu.BLOCK_ATLAS, barkTextureLocation));
        this.ringsTexture = spriteGetter.apply(new Material(InventoryMenu.BLOCK_ATLAS, ringsTextureLocation));
        this.initModels();
    }

    private void initModels() {
        for (int i = 0; i < 8; ++i) {
            int radius = i + 1;
            if (radius < 8) {
                for (Direction dir : Direction.values()) {
                    this.sleeves[dir.get3DDataValue()][i] = this.bakeSleeve(radius, dir, this.barkTexture);
                }
            }
            this.cores[0][i] = this.bakeCore(radius, Direction.Axis.Y, this.barkTexture);
            this.cores[1][i] = this.bakeCore(radius, Direction.Axis.Z, this.barkTexture);
            this.cores[2][i] = this.bakeCore(radius, Direction.Axis.X, this.barkTexture);
            this.rings[i] = this.bakeCore(radius, Direction.Axis.Y, this.ringsTexture);
        }
    }

    public BlockElement generateSleevePart(int radius, Direction dir, boolean flipNormals) {
        boolean negative;
        int dradius = radius * 2;
        int halfSize = (16 - dradius) / 2;
        int halfSizeX = dir.getStepX() != 0 ? halfSize : dradius;
        int halfSizeY = dir.getStepY() != 0 ? halfSize : dradius;
        int halfSizeZ = dir.getStepZ() != 0 ? halfSize : dradius;
        int move = 16 - halfSize;
        int centerX = 16 + dir.getStepX() * move;
        int centerY = 16 + dir.getStepY() * move;
        int centerZ = 16 + dir.getStepZ() * move;
        Vector3f posFrom = new Vector3f((float)(centerX - halfSizeX) / 2.0f, (float)(centerY - halfSizeY) / 2.0f, (float)(centerZ - halfSizeZ) / 2.0f);
        Vector3f posTo = new Vector3f((float)(centerX + halfSizeX) / 2.0f, (float)(centerY + halfSizeY) / 2.0f, (float)(centerZ + halfSizeZ) / 2.0f);
        if (flipNormals) {
            Vector3f aux = posFrom;
            posFrom = posTo;
            posTo = aux;
            dir = dir.getOpposite();
        }
        boolean bl = negative = dir.getAxisDirection() == Direction.AxisDirection.NEGATIVE;
        if (dir.getAxis() == Direction.Axis.Z) {
            negative = !negative;
        }
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            if (dir.getOpposite() == face) continue;
            BlockFaceUV uvface = null;
            if (dir == face) {
                if (radius == 1) {
                    uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, 0);
                }
            } else {
                uvface = new BlockFaceUV(new float[]{8 - radius, negative ? (float)(16 - halfSize) : 0.0f, 8 + radius, negative ? 16.0f : (float)halfSize}, this.getFaceAngle(dir.getAxis(), face));
            }
            if (uvface == null) continue;
            mapFacesIn.put(face, new BlockElementFace(null, -1, null, uvface));
        }
        return new BlockElement(posFrom, posTo, (Map)mapFacesIn, null, true);
    }

    public BakedModel bakeSleeve(int radius, Direction dir, TextureAtlasSprite bark) {
        BlockElement part = this.generateSleevePart(radius, dir, false);
        IModelBuilder<?> builder = ModelHelper.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, bark);
        for (Map.Entry e : part.faces.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelHelper.makeBakedQuad(part, (BlockElementFace)e.getValue(), bark, face, BlockModelRotation.X0_Y0));
        }
        return builder.build();
    }

    protected BlockElement generateCorePart(int radius, Direction.Axis axis, boolean flipNormals) {
        Vector3f posFrom = new Vector3f((float)(8 - radius), (float)(8 - radius), (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)(8 + radius), (float)(8 + radius));
        if (flipNormals) {
            Vector3f aux = posFrom;
            posFrom = posTo;
            posTo = aux;
        }
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            BlockFaceUV uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, this.getFaceAngle(axis, face));
            mapFacesIn.put(face, new BlockElementFace(null, -1, null, uvface));
        }
        return new BlockElement(posFrom, posTo, (Map)mapFacesIn, null, true);
    }

    public BakedModel bakeCore(int radius, Direction.Axis axis, TextureAtlasSprite icon) {
        BlockElement part = this.generateCorePart(radius, axis, false);
        IModelBuilder<?> builder = ModelHelper.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, icon);
        for (Map.Entry e : part.faces.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelHelper.makeBakedQuad(part, (BlockElementFace)e.getValue(), icon, face, BlockModelRotation.X0_Y0));
        }
        return builder.build();
    }

    public int getFaceAngle(Direction.Axis axis, Direction face) {
        if (axis == Direction.Axis.Y) {
            return 0;
        }
        if (axis == Direction.Axis.Z) {
            return switch (face) {
                case Direction.UP -> 0;
                case Direction.WEST -> 270;
                case Direction.DOWN -> 180;
                default -> 90;
            };
        }
        return face == Direction.NORTH ? 270 : 90;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        if (state == null || side != null) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quadsList = new ArrayList<BakedQuad>(24);
        int coreRadius = this.getRadius(state);
        if (coreRadius > 8) {
            return Collections.emptyList();
        }
        int[] connections = new int[]{0, 0, 0, 0, 0, 0};
        Direction forceRingDir = null;
        AtomicInteger twigRadius = new AtomicInteger(1);
        ModelConnections connectionsData = (ModelConnections)extraData.get(ModelConnections.CONNECTIONS_PROPERTY);
        if (connectionsData != null) {
            connections = connectionsData.getAllRadii();
            forceRingDir = connectionsData.getRingOnly();
            connectionsData.getFamily().ifValid(family -> twigRadius.set(family.getPrimaryThickness()));
        }
        int numConnections = 0;
        for (int i : connections) {
            numConnections += i != 0 ? 1 : 0;
        }
        if (numConnections == 0 && forceRingDir != null) {
            quadsList.addAll(this.rings[coreRadius - 1].getQuads(state, forceRingDir, rand, extraData, renderType));
        } else {
            Direction sourceDir = this.getSourceDir(coreRadius, connections);
            int coreDir = this.resolveCoreDir(sourceDir);
            Direction coreRingDir = numConnections == 1 && sourceDir != null ? sourceDir.getOpposite() : null;
            for (Direction face : Direction.values()) {
                if (coreRadius != connections[face.get3DDataValue()]) {
                    if (coreRingDir == null || coreRingDir != face) {
                        quadsList.addAll(this.cores[coreDir][coreRadius - 1].getQuads(state, face, rand, extraData, renderType));
                    } else {
                        quadsList.addAll(this.rings[coreRadius - 1].getQuads(state, face, rand, extraData, renderType));
                    }
                }
                if (coreRadius == 8) continue;
                for (Direction connDir : Direction.values()) {
                    int idx = connDir.get3DDataValue();
                    int connRadius = connections[idx];
                    if (connRadius <= 0 || connRadius != twigRadius.get() && face == connDir) continue;
                    quadsList.addAll(this.sleeves[idx][connRadius - 1].getQuads(state, face, rand, extraData, renderType));
                }
            }
        }
        return quadsList;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData tileData) {
        ModelConnections modelConnections;
        Block block = state.getBlock();
        if (block instanceof BranchBlock) {
            BranchBlock branchBlock = (BranchBlock)block;
            modelConnections = new ModelConnections(branchBlock.getConnectionData(world, pos, state)).setFamily(branchBlock.getFamily());
        } else {
            modelConnections = new ModelConnections();
        }
        return modelConnections.toModelData(tileData);
    }

    @Nullable
    protected Direction getSourceDir(int coreRadius, int[] connections) {
        int largestConnection = 0;
        Direction sourceDir = null;
        for (Direction dir : Direction.values()) {
            int connRadius = connections[dir.get3DDataValue()];
            if (connRadius <= largestConnection) continue;
            largestConnection = connRadius;
            sourceDir = dir;
        }
        if (largestConnection < coreRadius) {
            sourceDir = null;
        }
        return sourceDir;
    }

    protected int resolveCoreDir(@Nullable Direction dir) {
        if (dir == null) {
            return 0;
        }
        return dir.get3DDataValue() >> 1;
    }

    protected int getRadius(BlockState blockState) {
        return ((BranchBlock)blockState.getBlock()).getRadius(blockState);
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.barkTexture;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    @NotNull
    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{this.getRenderType()});
    }

    public RenderType getRenderType() {
        ResourceLocation renderTypeHint = this.blockModel.customData.getRenderTypeHint();
        if (renderTypeHint == null) {
            return RenderType.solid();
        }
        return NamedRenderTypeManager.get((ResourceLocation)renderTypeHint).block();
    }
}

