/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.data.tags.DTBiomeTags;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.utility.CoordUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class BeeNestGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> NEST_BLOCK = ConfigurationProperty.block("nest");
    public static final ConfigurationProperty<WorldGenChanceFunction> WORLD_GEN_CHANCE_FUNCTION = ConfigurationProperty.property("world_gen_chance", WorldGenChanceFunction.class);
    private static final double GUARANTEED_CHANCE = 1.0;
    private static final double COMMON_CHANCE = 0.05;
    private static final double UNCOMMON_CHANCE = 0.02;
    private static final double RARE_CHANCE = 2.0E-4;
    private static final double GROW_CHANCE = 0.001;

    public BeeNestGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(NEST_BLOCK, MAX_HEIGHT, CAN_GROW_PREDICATE, WORLD_GEN_CHANCE_FUNCTION, MAX_COUNT);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(NEST_BLOCK, Blocks.BEE_NEST)).with(MAX_HEIGHT, 32)).with(CAN_GROW_PREDICATE, (world, pos) -> {
            if ((double)world.getRandom().nextFloat() > 0.001) {
                return false;
            }
            for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.below().north(2).west(2), (BlockPos)pos.above().south(2).east(2))) {
                if (!world.getBlockState(blockpos).is(BlockTags.FLOWERS)) continue;
                return true;
            }
            return false;
        })).with(WORLD_GEN_CHANCE_FUNCTION, (world, pos) -> {
            Holder biomeHolder = world.getUncachedNoiseBiome(pos.getX() >> 2, pos.getY() >> 2, pos.getZ() >> 2);
            if (biomeHolder.is(DTBiomeTags.IS_BEE_NEST_GUARANTEED)) {
                return 1.0;
            }
            if (biomeHolder.is(DTBiomeTags.IS_BEE_NEST_COMMON)) {
                return 0.05;
            }
            if (biomeHolder.is(DTBiomeTags.IS_BEE_NEST_UNCOMMON)) {
                return 0.02;
            }
            return biomeHolder.is(DTBiomeTags.IS_BEE_NEST_RARE) ? 2.0E-4 : 0.0;
        })).with(MAX_COUNT, 1);
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        LevelAccessor world = context.level();
        BlockPos rootPos = context.pos();
        return (double)world.getRandom().nextFloat() <= (Double)configuration.get(WORLD_GEN_CHANCE_FUNCTION).apply(world, rootPos) && this.placeBeeNestInValidPlace(configuration, world, rootPos, true, context.random());
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (!context.natural() || !((GenFeature.CanGrowPredicate)configuration.get(CAN_GROW_PREDICATE)).test(context.level(), context.pos().above()) || context.fertility() == 0) {
            return false;
        }
        return this.placeBeeNestInValidPlace(configuration, context.level(), context.pos(), false, context.random());
    }

    private boolean placeBeeNestInValidPlace(GenFeatureConfiguration configuration, LevelAccessor world, BlockPos rootPos, boolean worldGen, RandomSource random) {
        int treeHeight;
        Block nestBlock = configuration.get(NEST_BLOCK);
        if (this.nestAlreadyPresent(world, nestBlock, rootPos, treeHeight = this.getTreeHeight(world, rootPos, (Integer)configuration.get(MAX_HEIGHT)))) {
            return false;
        }
        List<Pair<BlockPos, List<Direction>>> validSpaces = this.findBranchPits(configuration, world, rootPos, treeHeight);
        if (validSpaces == null) {
            return false;
        }
        if (validSpaces.size() > 0) {
            Pair<BlockPos, List<Direction>> chosenSpace = validSpaces.get(world.getRandom().nextInt(validSpaces.size()));
            Direction chosenDir = (Direction)((List)chosenSpace.getValue()).get(world.getRandom().nextInt(((List)chosenSpace.getValue()).size()));
            return this.placeBeeNestWithBees(world, nestBlock, (BlockPos)chosenSpace.getKey(), chosenDir, worldGen, random);
        }
        return false;
    }

    private boolean placeBeeNestWithBees(LevelAccessor world, Block nestBlock, BlockPos pos, Direction faceDir, boolean worldGen, RandomSource random) {
        BlockState nestState = nestBlock.defaultBlockState();
        if (nestState.hasProperty((Property)BeehiveBlock.FACING)) {
            nestState = (BlockState)nestState.setValue((Property)BeehiveBlock.FACING, (Comparable)faceDir);
        }
        world.setBlock(pos, nestState, 3);
        world.getBlockEntity(pos, BlockEntityType.BEEHIVE).ifPresent(blockEntity -> {
            int j = 2 + random.nextInt(2);
            for (int k = 0; k < j; ++k) {
                blockEntity.storeBee(BeehiveBlockEntity.Occupant.create((int)random.nextInt(599)));
            }
        });
        return true;
    }

    @Nullable
    private Level worldFromIWorld(LevelAccessor iWorld) {
        if (iWorld instanceof WorldGenRegion) {
            return ((WorldGenRegion)iWorld).getLevel();
        }
        if (iWorld instanceof Level) {
            return (Level)iWorld;
        }
        return null;
    }

    private boolean nestAlreadyPresent(LevelAccessor world, Block nestBlock, BlockPos rootPos, int maxHeight) {
        for (int y = 2; y < maxHeight; ++y) {
            BlockPos trunkPos = rootPos.above(y);
            for (Direction dir : CoordUtils.HORIZONTALS) {
                if (world.getBlockState(trunkPos.relative(dir)).getBlock() != nestBlock) continue;
                return true;
            }
        }
        return false;
    }

    private int getTreeHeight(LevelAccessor world, BlockPos rootPos, int maxHeight) {
        for (int i = 1; i < maxHeight; ++i) {
            if (TreeHelper.isBranch(world.getBlockState(rootPos.above(i)))) continue;
            return i - 1;
        }
        return maxHeight;
    }

    @Nullable
    private List<Pair<BlockPos, List<Direction>>> findBranchPits(GenFeatureConfiguration configuration, LevelAccessor world, BlockPos rootPos, int maxHeight) {
        int existingBlocks = 0;
        LinkedList<Pair<BlockPos, List<Direction>>> validSpaces = new LinkedList<Pair<BlockPos, List<Direction>>>();
        for (int y = 2; y < maxHeight; ++y) {
            BlockPos trunkPos = rootPos.above(y);
            for (Direction dir : CoordUtils.HORIZONTALS) {
                BlockPos sidePos = trunkPos.relative(dir);
                if (world.isEmptyBlock(sidePos) && TreeHelper.isBranch(world.getBlockState(sidePos.above()))) {
                    LinkedList<Direction> validDirs = new LinkedList<Direction>();
                    for (Direction dir2 : CoordUtils.HORIZONTALS) {
                        if (!world.isEmptyBlock(sidePos.relative(dir2))) continue;
                        validDirs.add(dir2);
                    }
                    if (validDirs.size() <= 0) continue;
                    validSpaces.add((Pair<BlockPos, List<Direction>>)Pair.of((Object)sidePos, validDirs));
                    continue;
                }
                if (world.getBlockState(sidePos).getBlock() != configuration.get(NEST_BLOCK) || ++existingBlocks <= (Integer)configuration.get(MAX_COUNT)) continue;
                return null;
            }
        }
        return validSpaces;
    }

    public static interface WorldGenChanceFunction
    extends BiFunction<LevelAccessor, BlockPos, Double> {
    }
}

