/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PreGenerationContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;

public class ClearVolumeGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Integer> HEIGHT = ConfigurationProperty.integer("height");

    public ClearVolumeGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(HEIGHT);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)super.createDefaultConfiguration().with(HEIGHT, 8);
    }

    @Override
    protected BlockPos preGenerate(GenFeatureConfiguration configuration, PreGenerationContext context) {
        BlockPos rootPos = context.pos();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)rootPos.offset(new Vec3i(-1, 1, -1)), (BlockPos)rootPos.offset(new Vec3i(1, configuration.get(HEIGHT).intValue(), 1)))) {
            context.level().removeBlock(pos, false);
        }
        return rootPos;
    }
}

