/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.voxmap.BlockPosBounds;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.FullGenerationContext;
import com.dtteam.dynamictrees.tree.ChunkTreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.google.common.collect.Iterables;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HugeMushroomGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> MUSHROOM_BLOCK = ConfigurationProperty.block("mushroom");
    public static final ConfigurationProperty<Block> STEM_BLOCK = ConfigurationProperty.block("stem");
    private int height = -1;
    static final SimpleVoxmap BROWN_CAP = new SimpleVoxmap(7, 1, 7, new byte[]{0, 1, 2, 2, 2, 3, 0, 1, 5, 5, 5, 5, 5, 3, 4, 5, 5, 5, 5, 5, 6, 4, 5, 5, 5, 5, 5, 6, 4, 5, 5, 5, 5, 5, 6, 7, 5, 5, 5, 5, 5, 9, 0, 7, 8, 8, 8, 9, 0}).setCenter(new BlockPos(3, 0, 3));
    static final SimpleVoxmap BROWN_CAP_MEDIUM = new SimpleVoxmap(5, 1, 5, new byte[]{0, 1, 2, 3, 0, 1, 5, 5, 5, 3, 4, 5, 5, 5, 6, 7, 5, 5, 5, 9, 0, 7, 8, 9, 0}).setCenter(new BlockPos(2, 0, 2));
    static final SimpleVoxmap BROWN_CAP_SMALL = new SimpleVoxmap(3, 1, 3, new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}).setCenter(new BlockPos(1, 0, 1));
    static final SimpleVoxmap RED_CAP = new SimpleVoxmap(5, 4, 5, new byte[]{0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 0, 0, 4, 5, 6, 0, 0, 7, 8, 9, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(2, 3, 2));
    static final SimpleVoxmap RED_CAP_SHORT = new SimpleVoxmap(5, 3, 5, new byte[]{0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 0, 0, 4, 5, 6, 0, 0, 7, 8, 9, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(2, 2, 2));
    static final SimpleVoxmap RED_CAP_SMALL = new SimpleVoxmap(3, 2, 3, new byte[]{1, 2, 3, 4, 10, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8, 9}).setCenter(new BlockPos(1, 1, 1));
    protected int maxHeightBase = 5;
    protected int maxHeightVar = 6;

    public HugeMushroomGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(MUSHROOM_BLOCK, STEM_BLOCK);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MUSHROOM_BLOCK, Blocks.AIR)).with(STEM_BLOCK, Blocks.MUSHROOM_STEM);
    }

    @Override
    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        return !Services.PLATFORM.isModLoaded("dynamictreesplus");
    }

    public HugeMushroomGenFeature setHeight(int height) {
        this.height = height;
        return this;
    }

    protected SimpleVoxmap getCapForHeight(Block mushroomBlock, int height) {
        if (mushroomBlock == Blocks.BROWN_MUSHROOM_BLOCK) {
            return switch (height) {
                case 2, 3 -> BROWN_CAP_SMALL;
                case 4, 5 -> BROWN_CAP_MEDIUM;
                default -> BROWN_CAP;
            };
        }
        return switch (height) {
            case 2 -> BROWN_CAP_SMALL;
            case 3 -> RED_CAP_SMALL;
            case 4 -> RED_CAP_SHORT;
            default -> RED_CAP;
        };
    }

    protected int getMushroomHeight(LevelAccessor level, BlockPos rootPos, Biome biome, RandomSource random, int radius) {
        return this.height > 0 ? this.height : random.nextInt(this.maxHeightVar) + this.maxHeightBase;
    }

    @Override
    protected boolean generate(GenFeatureConfiguration configuration, FullGenerationContext context) {
        return this.generateMushrooms(configuration, context);
    }

    protected boolean generateMushrooms(GenFeatureConfiguration configuration, FullGenerationContext context) {
        LevelAccessor level = context.level();
        BlockPos rootPos = context.pos();
        BlockPos genPos = rootPos.above();
        int height = this.getMushroomHeight(level, rootPos, (Biome)context.biome().value(), context.random(), context.radius());
        BlockState soilState = level.getBlockState(rootPos);
        if (context.species().isAcceptableSoilForWorldgen(level, rootPos, soilState)) {
            Block mushroomBlock = configuration.get(MUSHROOM_BLOCK);
            if (mushroomBlock == Blocks.AIR) {
                mushroomBlock = context.random().nextBoolean() ? Blocks.BROWN_MUSHROOM_BLOCK : Blocks.RED_MUSHROOM_BLOCK;
            }
            SimpleVoxmap capMap = this.getCapForHeight(mushroomBlock, height);
            BlockPos capPos = genPos.above(height - 1);
            BlockPosBounds capBounds = capMap.getBounds().move(capPos);
            if (ChunkTreeHelper.canCheckSurroundings(level, capBounds.toAABB())) {
                for (Object mutPos : Iterables.concat((Iterable)BlockPos.betweenClosed((BlockPos)BlockPos.ZERO.below(capMap.getLenY()), (BlockPos)BlockPos.ZERO.below(height - 1)), capMap.getAllNonZero())) {
                    BlockPos dPos = mutPos.offset((Vec3i)capPos);
                    BlockState state = level.getBlockState(dPos);
                    if (state.canBeReplaced()) continue;
                    return false;
                }
                BlockState stemState = configuration.get(STEM_BLOCK).defaultBlockState();
                for (SimpleVoxmap.VoxmapCell cell : capMap.getAllNonZeroCells()) {
                    level.setBlock(capPos.offset((Vec3i)cell.getPos()), this.getMushroomStateForValue(mushroomBlock, stemState, cell.getValue(), cell.getPos().getY()), 2);
                }
                int stemLen = height - capMap.getLenY();
                for (int y = 0; y < stemLen; ++y) {
                    level.setBlock(genPos.above(y), stemState, 2);
                }
                return true;
            }
        }
        return false;
    }

    protected BlockState getMushroomStateForValue(Block mushroomBlock, BlockState stemBlock, int value, int y) {
        if (value == 10) {
            return stemBlock;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)mushroomBlock.defaultBlockState().setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(y >= -1))).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(value >= 1 && value <= 3))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(value >= 7 && value <= 9))).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(value == 1 || value == 4 || value == 7))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(value % 3 == 0));
    }
}

