/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostRotContext;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class MushroomRotGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> MUSHROOM = ConfigurationProperty.block("mushroom");
    public static final ConfigurationProperty<Block> ALTERNATE_MUSHROOM = ConfigurationProperty.block("alternate_mushroom");
    public static final ConfigurationProperty<Float> ALTERNATE_MUSHROOM_CHANCE = ConfigurationProperty.floatProperty("alternate_mushroom_chance");

    public MushroomRotGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(MUSHROOM, ALTERNATE_MUSHROOM, ALTERNATE_MUSHROOM_CHANCE);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MUSHROOM, Blocks.BROWN_MUSHROOM)).with(ALTERNATE_MUSHROOM, Blocks.RED_MUSHROOM)).with(ALTERNATE_MUSHROOM_CHANCE, Float.valueOf(0.25f));
    }

    @Override
    protected boolean postRot(GenFeatureConfiguration configuration, PostRotContext context) {
        Block mushroom;
        LevelAccessor level = context.level();
        BlockPos pos = context.pos();
        Block block = mushroom = configuration.get(ALTERNATE_MUSHROOM_CHANCE).floatValue() > context.random().nextFloat() ? configuration.get(MUSHROOM) : configuration.get(ALTERNATE_MUSHROOM);
        if (context.radius() <= 4 || !this.mayMushroomPlaceOn(level, pos) || level.getBrightness(LightLayer.SKY, pos) >= 4) {
            return false;
        }
        level.setBlock(pos, mushroom.defaultBlockState(), 3);
        return true;
    }

    private boolean mayMushroomPlaceOn(LevelAccessor level, BlockPos pos) {
        return level.getBlockState(pos).isSolidRender((BlockGetter)level, pos);
    }
}

