/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.systems.nodemapper.FindEndsNode;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.CoordUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class VinesGenFeature
extends GenFeature {
    protected final BooleanProperty[] sideVineStates = new BooleanProperty[]{null, null, VineBlock.NORTH, VineBlock.SOUTH, VineBlock.WEST, VineBlock.EAST};
    public static final ConfigurationProperty<Integer> MAX_LENGTH = ConfigurationProperty.integer("max_length");
    public static final ConfigurationProperty<Block> BLOCK = ConfigurationProperty.block("block");
    public static final ConfigurationProperty<Block> TIP_BLOCK = ConfigurationProperty.block("tip_block");
    public static final ConfigurationProperty<VineType> VINE_TYPE = ConfigurationProperty.property("vine_type", VineType.class);

    public VinesGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(QUANTITY, MAX_LENGTH, VERTICAL_SPREAD, RAY_DISTANCE, BLOCK, TIP_BLOCK, VINE_TYPE, FRUITING_RADIUS);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(QUANTITY, 4)).with(MAX_LENGTH, 8)).with(VERTICAL_SPREAD, Float.valueOf(60.0f))).with(RAY_DISTANCE, Float.valueOf(5.0f))).with(BLOCK, Blocks.VINE)).with(TIP_BLOCK, null)).with(VINE_TYPE, VineType.SIDE)).with(FRUITING_RADIUS, -1);
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (!context.isWorldGen() || context.endPoints().isEmpty()) {
            return false;
        }
        VineType vineType = configuration.get(VINE_TYPE);
        int quantity = (Integer)configuration.get(QUANTITY);
        block4: for (int i = 0; i < quantity; ++i) {
            BlockPos endPoint = context.endPoints().get(context.random().nextInt(context.endPoints().size()));
            switch (vineType.ordinal()) {
                case 2: {
                    this.addSideVines(configuration, context.level(), context.species(), context.pos(), endPoint, true);
                    continue block4;
                }
                case 0: 
                case 1: {
                    this.addVerticalVines(configuration, context.level(), context.species(), context.pos(), endPoint, true);
                }
            }
        }
        return true;
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        LevelAccessor level = context.level();
        BlockPos rootPos = context.pos();
        Species species = context.species();
        int fruitingRadius = (Integer)configuration.get(FRUITING_RADIUS);
        if (fruitingRadius < 0 || context.fertility() < 1) {
            return false;
        }
        BlockState blockState = level.getBlockState(context.treePos());
        BranchBlock branch = TreeHelper.getBranch(blockState);
        if (branch != null && branch.getRadius(blockState) >= fruitingRadius && context.natural() && species.seasonalFruitProductionFactor(context.levelContext(), rootPos) > level.getRandom().nextFloat()) {
            FindEndsNode endFinder = new FindEndsNode();
            TreeHelper.startAnalysisFromRoot(level, rootPos, new MapSignal(endFinder));
            List<BlockPos> endPoints = endFinder.getEnds();
            int qty = (Integer)configuration.get(QUANTITY);
            if (!endPoints.isEmpty()) {
                for (int i = 0; i < qty; ++i) {
                    BlockPos endPoint = endPoints.get(level.getRandom().nextInt(endPoints.size()));
                    if (configuration.get(VINE_TYPE) == VineType.SIDE) {
                        this.addSideVines(configuration, level, species, rootPos, endPoint, false);
                        continue;
                    }
                    this.addVerticalVines(configuration, level, species, rootPos, endPoint, false);
                }
                return true;
            }
        }
        return true;
    }

    protected void addSideVines(GenFeatureConfiguration configuration, LevelAccessor level, Species species, BlockPos rootPos, BlockPos branchPos, boolean worldgen) {
        BlockHitResult result = CoordUtils.branchRayTrace(level, species, rootPos, branchPos, 90.0f, ((Float)configuration.get(VERTICAL_SPREAD)).floatValue(), ((Float)configuration.get(RAY_DISTANCE)).floatValue());
        if (result == null) {
            return;
        }
        BlockPos vinePos = result.getBlockPos().relative(result.getDirection());
        if (vinePos == BlockPos.ZERO) {
            return;
        }
        BooleanProperty vineSide = this.sideVineStates[result.getDirection().getOpposite().ordinal()];
        if (vineSide == null) {
            return;
        }
        BlockState vineState = (BlockState)configuration.get(BLOCK).defaultBlockState().setValue((Property)vineSide, (Comparable)Boolean.valueOf(true));
        this.placeVines(level, vinePos, vineState, configuration.get(MAX_LENGTH), null, configuration.get(VINE_TYPE), worldgen);
    }

    protected void addVerticalVines(GenFeatureConfiguration configuration, LevelAccessor level, Species species, BlockPos rootPos, BlockPos branchPos, boolean worldgen) {
        BlockPos vinePos = CoordUtils.getRayTraceFruitPos(level, species, rootPos, branchPos, worldgen);
        if (configuration.get(VINE_TYPE) == VineType.FLOOR) {
            vinePos = this.findGround(level, vinePos);
        }
        if (vinePos == BlockPos.ZERO) {
            return;
        }
        this.placeVines(level, vinePos, configuration.get(BLOCK).defaultBlockState(), configuration.get(MAX_LENGTH), configuration.getAsOptional(TIP_BLOCK).map(block -> (BlockState)block.defaultBlockState().setValue((Property)GrowingPlantHeadBlock.AGE, (Comparable)Integer.valueOf(worldgen ? 25 : 0))).orElse(null), configuration.get(VINE_TYPE), worldgen);
    }

    private BlockPos findGround(LevelAccessor level, BlockPos vinePos) {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(vinePos.getX(), vinePos.getY(), vinePos.getZ());
        do {
            mPos.move(Direction.DOWN);
            if (mPos.getY() > 0) continue;
            return BlockPos.ZERO;
        } while (level.isEmptyBlock(vinePos) || level.getBlockState(vinePos).getBlock() instanceof DynamicLeavesBlock);
        return mPos.above();
    }

    protected void placeVines(LevelAccessor level, BlockPos vinePos, BlockState vinesState, int maxLength, @Nullable BlockState tipState, VineType vineType, boolean worldGen) {
        int len = worldGen ? Mth.clamp((int)(level.getRandom().nextInt(maxLength) + 3), (int)3, (int)maxLength) : 1;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(vinePos.getX(), vinePos.getY(), vinePos.getZ());
        tipState = tipState == null ? vinesState : tipState;
        for (int i = 0; i < len; ++i) {
            if (!level.isEmptyBlock((BlockPos)mPos)) {
                if (i <= 0 || vineType == VineType.SIDE) break;
                mPos.setY(mPos.getY() + (vineType == VineType.FLOOR ? -1 : 1));
                level.setBlock((BlockPos)mPos, tipState, 3);
                break;
            }
            level.setBlock((BlockPos)mPos, i == len - 1 ? tipState : vinesState, 3);
            mPos.setY(mPos.getY() + (vineType == VineType.FLOOR ? 1 : -1));
        }
    }

    public static enum VineType {
        CEILING,
        FLOOR,
        SIDE;

    }
}

