/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.growthlogic;

import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKit;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKitConfiguration;
import com.dtteam.dynamictrees.systems.growthlogic.context.DirectionManipulationContext;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.utility.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class AzaleaLogic
extends GrowthLogicKit {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public AzaleaLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = context.probMap();
        Direction originDir = context.signal().dir.getOpposite();
        for (Direction dir : Direction.values()) {
            if (dir == originDir) continue;
            BlockPos deltaPos = context.pos().relative(dir);
            BlockState deltaBlockState = context.level().getBlockState(deltaPos);
            int n = dir.get3DDataValue();
            probMap[n] = probMap[n] + TreeHelper.getTreePart(deltaBlockState).probabilityForBlock(deltaBlockState, (BlockGetter)context.level(), deltaPos, context.branch());
        }
        GrowSignal signal = context.signal();
        int deltaY = Math.abs(signal.delta.getY());
        int distFromTrunk = Math.max(Math.abs(signal.delta.getX()), Math.abs(signal.delta.getZ()));
        float horizontalMultiplier = signal.isInTrunk() ? 1.0f : 1.0f / (float)distFromTrunk;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            int n = dir.get3DDataValue();
            probMap[n] = (int)((float)probMap[n] * ((float)deltaY * horizontalMultiplier));
        }
        if (!signal.isInTrunk()) {
            if (originDir != Direction.UP) {
                int n = Direction.UP.get3DDataValue();
                probMap[n] = probMap[n] + distFromTrunk * 2;
            }
            probMap[Direction.DOWN.get3DDataValue()] = 0;
        } else {
            int n = Direction.UP.get3DDataValue();
            probMap[n] = probMap[n] * 2;
        }
        int i = 2;
        while (i < 6) {
            int n = i++;
            probMap[n] = (int)((double)probMap[n] * 0.5);
        }
        int n = AzaleaLogic.getDirectionBias(signal.rootPos).get3DDataValue();
        probMap[n] = probMap[n] * 8;
        return probMap;
    }

    private static Direction getDirectionBias(BlockPos rootPos) {
        return HORIZONTALS[CoordUtils.coordHashCode(rootPos, 0) % 4];
    }
}

