/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.growthlogic;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKit;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKitConfiguration;
import com.dtteam.dynamictrees.systems.growthlogic.context.DirectionManipulationContext;
import com.dtteam.dynamictrees.systems.growthlogic.context.DirectionSelectionContext;
import com.dtteam.dynamictrees.systems.growthlogic.context.PositionalSpeciesContext;
import com.dtteam.dynamictrees.utility.CoordUtils;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class JungleLogic
extends GrowthLogicKit {
    public static final ConfigurationProperty<Integer> CANOPY_HEIGHT = ConfigurationProperty.integer("canopy_height");
    public static final ConfigurationProperty<Integer> BRANCH_OUT_CHANCE = ConfigurationProperty.integer("branch_out_chance");

    public JungleLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(CANOPY_HEIGHT, 14)).with(BRANCH_OUT_CHANCE, 5);
    }

    @Override
    protected void registerProperties() {
        this.register(CANOPY_HEIGHT, BRANCH_OUT_CHANCE);
    }

    @Override
    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        Direction newDir = super.selectNewDirection(configuration, context);
        if (context.signal().isInTrunk() && newDir != Direction.UP) {
            context.signal().energy = 4.0f;
        }
        return newDir;
    }

    @Override
    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = super.populateDirectionProbabilityMap(configuration, context);
        Direction originDir = context.signal().dir.getOpposite();
        int treeHash = CoordUtils.coordHashCode(context.signal().rootPos, 2);
        int posHash = CoordUtils.coordHashCode(context.pos(), 2);
        probMap[0] = 0;
        probMap[1] = context.signal().isInTrunk() ? context.species().getUpProbability() : 0;
        probMap[5] = 0;
        probMap[4] = 0;
        probMap[3] = 0;
        probMap[2] = 0;
        boolean branchOut = (context.signal().numSteps + treeHash) % configuration.get(BRANCH_OUT_CHANCE) == 0;
        int sideTurn = !context.signal().isInTrunk() || context.signal().isInTrunk() && branchOut && context.radius() > 1 ? 2 : 0;
        int height = configuration.get(CANOPY_HEIGHT) + treeHash % 7829 % 8;
        if (context.signal().delta.getY() < height) {
            probMap[2 + posHash % 4] = sideTurn;
        } else {
            probMap[5] = 2;
            probMap[4] = 2;
            probMap[3] = 2;
            probMap[2] = 2;
            probMap[1] = 2;
        }
        probMap[originDir.ordinal()] = 0;
        int n = context.signal().dir.ordinal();
        probMap[n] = probMap[n] + (context.signal().isInTrunk() ? 0 : (context.signal().numTurns == 1 ? 2 : 1));
        return probMap;
    }

    @Override
    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return super.getEnergy(configuration, context) * context.species().biomeSuitability(context.level(), context.pos());
    }
}

