/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.nodemapper;

import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.BranchConnectables;
import com.dtteam.dynamictrees.systems.nodemapper.FindEndsNode;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DestroyerNode
extends FindEndsNode {
    Species species;
    private Player player = null;

    public DestroyerNode(Species species) {
        this.species = species;
    }

    public DestroyerNode setPlayer(Player player) {
        this.player = player;
        return this;
    }

    @Override
    public boolean run(BlockState state, LevelAccessor accessor, BlockPos pos, @Nullable Direction fromDir) {
        BranchBlock branch;
        if (BranchConnectables.getConnectionRadiusForBlock(state, (BlockGetter)accessor, pos, fromDir == null ? null : fromDir.getOpposite()) > 0) {
            if (this.player != null && accessor instanceof Level) {
                Level level = (Level)accessor;
                BlockEntity te = accessor.getBlockEntity(pos);
                Services.INTERACTION.blockDestroyByPlayer(state, level, pos, this.player, false, level.getFluidState(pos));
                state.getBlock().playerDestroy(level, this.player, pos, state, te, this.player.getMainHandItem());
            } else {
                accessor.setBlock(pos, Blocks.AIR.defaultBlockState(), 0);
            }
        }
        if ((branch = TreeHelper.getBranch(state)) != null && this.species.getFamily() == branch.getFamily()) {
            accessor.setBlock(pos, branch.getStateForDecay(state, accessor, pos), 3);
        }
        return super.run(state, accessor, pos, fromDir);
    }

    @Override
    public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        return super.returnRun(state, level, pos, fromDir);
    }
}

