/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.poissondisc;

import com.dtteam.dynamictrees.api.worldgen.PoissonDebug;
import com.dtteam.dynamictrees.api.worldgen.PoissonDiscProvider;
import com.dtteam.dynamictrees.api.worldgen.RadiusCoordinator;
import com.dtteam.dynamictrees.api.worldgen.RandomXOR;
import com.dtteam.dynamictrees.systems.poissondisc.PoissonDisc;
import com.dtteam.dynamictrees.systems.poissondisc.PoissonDiscChunkSet;
import com.dtteam.dynamictrees.systems.poissondisc.PoissonDiscHelper;
import com.dtteam.dynamictrees.systems.poissondisc.Vec2i;
import com.dtteam.dynamictrees.utility.CoordUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;

public class LevelPoissonDiscProvider
implements PoissonDiscProvider {
    private final RadiusCoordinator radiusCoordinator;
    private final HashMap<ChunkPos, PoissonDiscChunkSet> chunkDiscs;
    private RandomXOR random = new RandomXOR();
    private PoissonDebug debug = PoissonDebug.EMPTY_POISSON_DEBUG;
    private final List<PoissonDisc> discCache1 = new ArrayList<PoissonDisc>(64);
    private final List<PoissonDisc> discCache2 = new ArrayList<PoissonDisc>(64);

    public LevelPoissonDiscProvider(RadiusCoordinator radCoord) {
        this.chunkDiscs = new HashMap();
        this.radiusCoordinator = radCoord;
    }

    public LevelPoissonDiscProvider setSeed(Long seed) {
        if (seed != null) {
            this.random = new RandomXOR(seed);
        }
        return this;
    }

    public void setDebug(PoissonDebug debug) {
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PoissonDisc> getPoissonDiscs(int chunkX, int chunkY, int chunkZ) {
        LevelPoissonDiscProvider levelPoissonDiscProvider = this;
        synchronized (levelPoissonDiscProvider) {
            this.random.setXOR(new BlockPos(chunkX, chunkY, chunkZ));
            PoissonDiscChunkSet cSet = this.getChunkDiscSet(chunkX, chunkZ);
            if (cSet.generated) {
                return this.getChunkPoissonDiscs(chunkX, chunkZ);
            }
            int i = 0;
            List<PoissonDisc> output = null;
            while (this.radiusCoordinator.runPass(chunkX, chunkZ, i++)) {
                output = this.generatePoissonDiscs((RandomSource)this.random, chunkX, chunkZ);
            }
            return output;
        }
    }

    public List<PoissonDisc> generatePoissonDiscs(RandomSource random, int chunkX, int chunkZ) {
        List<PoissonDisc> allDiscs = this.discCache1;
        List<PoissonDisc> unsolvedDiscs = this.discCache2;
        allDiscs.clear();
        unsolvedDiscs.clear();
        this.debug.begin(chunkX, chunkZ);
        this.getChunkPoissonDiscs(allDiscs, chunkX, chunkZ);
        for (CoordUtils.Surround surr : CoordUtils.Surround.values()) {
            Vec3i dir = surr.getOffset();
            this.getChunkPoissonDiscs(allDiscs, chunkX + dir.getX(), chunkZ + dir.getZ());
        }
        this.debug.collectSolved(allDiscs);
        int chunkXStart = chunkX << 4;
        int chunkZStart = chunkZ << 4;
        for (PoissonDisc c : allDiscs) {
            c.edgeMask(chunkXStart, chunkZStart);
        }
        this.debug.doEdgeMasking(allDiscs);
        for (int i = 0; i < allDiscs.size() - 1; ++i) {
            for (int j = i + 1; j < allDiscs.size(); ++j) {
                PoissonDiscHelper.maskDiscs(allDiscs.get(i), allDiscs.get(j));
            }
        }
        this.debug.maskSolvedDiscs(allDiscs);
        if (allDiscs.isEmpty()) {
            int x = chunkXStart + random.nextInt(16);
            int z = chunkZStart + random.nextInt(16);
            int radius = this.radiusCoordinator.getRadiusAtCoords(x, z);
            PoissonDisc rootDisc = new PoissonDisc(x, z, radius);
            rootDisc.real = true;
            allDiscs.add(rootDisc);
            this.debug.createRootDisc(allDiscs, rootDisc);
        }
        PoissonDiscHelper.gatherUnsolved(unsolvedDiscs, allDiscs);
        this.debug.gatherUnsolved(unsolvedDiscs, allDiscs);
        int count = 0;
        while (!unsolvedDiscs.isEmpty()) {
            this.debug.updateCount(count, unsolvedDiscs, allDiscs);
            PoissonDisc master = unsolvedDiscs.getFirst();
            this.debug.pickMasterDisc(master, unsolvedDiscs, allDiscs);
            PoissonDisc slave = null;
            Vec2i slavePos = null;
            int radius = 0;
            for (int dir = 0; dir <= 1; ++dir) {
                boolean CCW = dir == 0;
                float angle = CCW ? (float)master.getFreeAngleCCW() : (float)master.getFreeAngleCW();
                double d = (double)master.x + (double)(Mth.sin((float)angle) * (float)master.radius) * 1.5;
                double dz = (double)master.z + (double)(Mth.cos((float)angle) * (float)master.radius) * 1.5;
                radius = this.radiusCoordinator.getRadiusAtCoords((int)d, (int)dz);
                this.debug.getRadius(master, radius, unsolvedDiscs, allDiscs);
                slave = PoissonDiscHelper.findSecondDisc(master, radius, true, CCW);
                slavePos = new Vec2i(slave);
                this.debug.findSecondDisc(master, slave, unsolvedDiscs, allDiscs);
                if (this.doesDiscIntersectWith(slave, allDiscs)) break;
            }
            master.arc |= 1 << master.getFreeBitCW();
            PoissonDiscHelper.maskDiscs(master, slave, true);
            this.debug.maskMasterSlave(master, slave, unsolvedDiscs, allDiscs);
            int i = 0;
            TreeMap<Integer, PoissonDisc> intersecting = new TreeMap<Integer, PoissonDisc>();
            for (PoissonDisc poissonDisc : allDiscs) {
                if (!slave.doCirclesIntersectPadding(poissonDisc)) continue;
                int depth = 16 + (int)poissonDisc.discPenetration(slave);
                intersecting.put(depth << 8 | i++, poissonDisc);
            }
            this.debug.intersectingList(slave, intersecting, allDiscs);
            for (Map.Entry entry : intersecting.entrySet()) {
                PoissonDisc master1 = master;
                PoissonDisc master2 = (PoissonDisc)entry.getValue();
                int cross = Vec2i.crossProduct(new Vec2i(slavePos).sub(master1), new Vec2i(master2).sub(master1));
                if (cross < 0) {
                    PoissonDisc temp = master2;
                    master2 = master1;
                    master1 = temp;
                }
                slave = PoissonDiscHelper.findThirdDisc(master1, master2, radius);
                this.debug.findThirdDiscCandidate(master1, master2, slave, unsolvedDiscs, allDiscs);
                if (slave == null) continue;
                for (int ci = 0; ci < allDiscs.size(); ++ci) {
                    PoissonDisc c = allDiscs.get(ci);
                    if (!slave.doCirclesIntersectPadding(c)) continue;
                    this.debug.thirdCircleCandidateIntersects(master1, master2, slave, c, unsolvedDiscs, allDiscs);
                    if (c.real || !slave.isInCenterChunk(chunkXStart, chunkZStart)) {
                        slave = null;
                        break;
                    }
                    PoissonDiscHelper.fastRemove(allDiscs, ci--);
                }
                this.debug.findThirdDiscSolved(slave, unsolvedDiscs, allDiscs);
                break;
            }
            if (slave != null) {
                slave.edgeMask(chunkXStart, chunkZStart);
                slave.real = slave.isInCenterChunk(chunkXStart, chunkZStart);
                unsolvedDiscs.add(slave);
                PoissonDiscHelper.solveDiscs(unsolvedDiscs, allDiscs);
                allDiscs.add(slave);
                this.debug.solveDiscs(unsolvedDiscs, allDiscs);
            }
            PoissonDiscHelper.gatherUnsolved(unsolvedDiscs, allDiscs);
            this.debug.gatherUnsolved2(unsolvedDiscs, allDiscs);
            if (++count <= 64 || unsolvedDiscs.isEmpty()) continue;
            this.debug.unsolvable(chunkX, chunkZ, count, unsolvedDiscs, allDiscs);
            break;
        }
        PoissonDiscChunkSet cSet = this.getChunkDiscSet(chunkX, chunkZ);
        cSet.generated = true;
        for (PoissonDisc disc : allDiscs) {
            if (!disc.isInCenterChunk(chunkXStart, chunkZStart)) continue;
            cSet.addDisc(disc);
        }
        return cSet.getDiscs(new ArrayList<PoissonDisc>(16), chunkX, chunkZ);
    }

    private boolean doesDiscIntersectWith(PoissonDisc disc, List<PoissonDisc> others) {
        for (PoissonDisc otherDisc : others) {
            if (!disc.doCirclesIntersectPadding(otherDisc)) continue;
            return true;
        }
        return false;
    }

    private PoissonDiscChunkSet getChunkDiscSet(int chunkX, int chunkZ) {
        PoissonDiscChunkSet cSet;
        ChunkPos key = new ChunkPos(chunkX, chunkZ);
        if (this.chunkDiscs.containsKey(key)) {
            cSet = this.chunkDiscs.get(key);
        } else {
            cSet = new PoissonDiscChunkSet();
            this.chunkDiscs.put(key, cSet);
        }
        return cSet;
    }

    @Override
    public byte[] getChunkPoissonData(int chunkX, int chunkY, int chunkZ) {
        return this.getChunkDiscSet(chunkX, chunkZ).getDiscData();
    }

    @Override
    public void setChunkPoissonData(int chunkX, int chunkY, int chunkZ, byte[] circleData) {
        this.getChunkDiscSet(chunkX, chunkZ).setDiscData(circleData);
    }

    @Override
    public void unloadChunkPoissonData(int chunkX, int chunkY, int chunkZ) {
        this.chunkDiscs.remove(new ChunkPos(chunkX, chunkZ));
    }

    private List<PoissonDisc> getChunkPoissonDiscs(int chunkX, int chunkZ) {
        return this.getChunkPoissonDiscs(new ArrayList<PoissonDisc>(), chunkX, chunkZ);
    }

    private List<PoissonDisc> getChunkPoissonDiscs(List<PoissonDisc> discs, int chunkX, int chunkZ) {
        PoissonDiscChunkSet cSet = this.getChunkDiscSet(chunkX, chunkZ);
        cSet.getDiscs(discs, chunkX, chunkZ);
        return discs;
    }
}

