/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.worldgen;

import com.dtteam.dynamictrees.worldgen.JoCode;
import com.dtteam.dynamictrees.worldgen.RootsJoCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public final class JoCodeRegistry {
    private static final Map<ResourceLocation, Map<Integer, List<JoCode>>> CODES = new HashMap<ResourceLocation, Map<Integer, List<JoCode>>>();
    private static final Map<ResourceLocation, Map<Integer, List<JoCode>>> ROOTS_CODES = new HashMap<ResourceLocation, Map<Integer, List<JoCode>>>();

    private JoCodeRegistry() {
    }

    public static void clear() {
        CODES.clear();
        ROOTS_CODES.clear();
    }

    public static void register(ResourceLocation speciesName, int radius, JoCode code) {
        CODES.computeIfAbsent(speciesName, s -> new HashMap()).computeIfAbsent(radius, r -> new ArrayList()).add(code);
    }

    public static void registerRoot(ResourceLocation speciesName, int radius, RootsJoCode code) {
        ROOTS_CODES.computeIfAbsent(speciesName, s -> new HashMap()).computeIfAbsent(radius, r -> new ArrayList()).add(code);
    }

    public static Map<Integer, List<JoCode>> getCodes(ResourceLocation speciesName, boolean roots) {
        return Collections.unmodifiableMap((roots ? ROOTS_CODES : CODES).getOrDefault(speciesName, new HashMap()));
    }

    public static List<JoCode> getCodes(ResourceLocation speciesName, int radius) {
        return JoCodeRegistry.getCodes(speciesName, radius, false);
    }

    public static List<JoCode> getCodes(ResourceLocation speciesName, int radius, boolean root) {
        return Collections.unmodifiableList(JoCodeRegistry.getCodes(speciesName, root).getOrDefault(radius, new ArrayList()));
    }

    @Nullable
    public static JoCode getRandomCode(ResourceLocation speciesName, int radius, RandomSource random) {
        return JoCodeRegistry.getRandomCode(speciesName, radius, random, false);
    }

    @Nullable
    public static JoCode getRandomCode(ResourceLocation speciesName, int radius, RandomSource random, boolean root) {
        List<JoCode> list = JoCodeRegistry.getCodes(speciesName, radius, root);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(random.nextInt(list.size()));
    }
}

