/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.data.generator;

import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.block.soil.SoilProperties;
import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.data.provider.DTBlockStateProvider;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;

public class SoilStateGenerator
implements Generator<DTDataProvider.BlockState, SoilProperties> {
    public static final Generator.DependencyKey<SoilBlock> SOIL = new Generator.DependencyKey("soil");
    public static final Generator.DependencyKey<Block> PRIMITIVE_SOIL = new Generator.DependencyKey("primitive_soil");

    @Override
    public void generate(DTDataProvider.BlockState prov, SoilProperties input, Generator.Dependencies dependencies) {
        if (prov instanceof DTBlockStateProvider) {
            DTBlockStateProvider provider = (DTBlockStateProvider)prov;
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)provider.getMultipartBuilder(dependencies.get(SOIL)).part().modelFile((ModelFile)provider.models().getExistingFile(input.getModelPath("soil_block").orElse(provider.block(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)dependencies.get(PRIMITIVE_SOIL))))))).addModel()).end().part().modelFile((ModelFile)provider.models().getExistingFile(input.getRootsOverlayModelLocation())).addModel()).end();
        }
    }

    @Override
    public boolean verifyInput(SoilProperties input) {
        return input.shouldGenerateBlock();
    }

    @Override
    public Generator.Dependencies gatherDependencies(SoilProperties input) {
        return new Generator.Dependencies().append(SOIL, input.getBlock()).append(PRIMITIVE_SOIL, input.getPrimitiveSoilBlockOptional());
    }
}

