/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.applier;

import com.dtteam.dynamictrees.api.lazyvalue.LazyValue;
import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.applier.Applier;
import com.dtteam.dynamictrees.deserialization.applier.PropertyApplier;
import com.dtteam.dynamictrees.deserialization.applier.PropertyApplierResult;
import com.dtteam.dynamictrees.deserialization.applier.VoidApplier;
import com.dtteam.dynamictrees.deserialization.deserializer.JsonDeserializer;
import com.google.gson.JsonElement;
import org.jetbrains.annotations.Nullable;

public final class JsonPropertyApplier<O, V>
extends PropertyApplier<O, V, JsonElement> {
    private final LazyValue<JsonDeserializer<V>> deserialiser = LazyValue.supplied(() -> JsonDeserializers.getOrThrow(valueClass));

    public JsonPropertyApplier(String key, Class<O> objectClass, Class<V> valueClass, VoidApplier<O, V> propertyApplier) {
        this(key, objectClass, valueClass, (Applier<O, V>)propertyApplier);
    }

    public JsonPropertyApplier(String key, Class<O> objectClass, Class<V> valueClass, Applier<O, V> applier) {
        super(key, objectClass, applier);
    }

    @Override
    @Nullable
    protected PropertyApplierResult applyIfShould(O object, JsonElement input, Applier<O, V> applier) {
        if (JsonDeserializers.JSON_NULL.deserialize(input).success()) {
            return JsonDeserializers.JSON_NULL.deserialize(input).map(value -> this.applier.apply(object, null)).orElseApply(PropertyApplierResult::failure, PropertyApplierResult::addWarnings, null);
        }
        return this.deserialiser.get().deserialize(input).map(value -> this.applier.apply(object, value)).orElseApply(PropertyApplierResult::failure, PropertyApplierResult::addWarnings, null);
    }
}

