/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.event.handler;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.sapling.PottedSaplingBlock;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.block.soil.SoilProperties;
import com.dtteam.dynamictrees.client.BlockColorMultipliers;
import com.dtteam.dynamictrees.client.TextureHelper;
import com.dtteam.dynamictrees.client.ThickBranchRingsSource;
import com.dtteam.dynamictrees.entity.render.FallingTreeRenderer;
import com.dtteam.dynamictrees.entity.render.LingeringEffectorRenderer;
import com.dtteam.dynamictrees.model.baked.BakedModelBlockPottedSapling;
import com.dtteam.dynamictrees.model.loader.BranchBlockModelLoader;
import com.dtteam.dynamictrees.model.loader.PalmLeavesModelLoader;
import com.dtteam.dynamictrees.model.loader.RootsBlockModelLoader;
import com.dtteam.dynamictrees.model.loader.SurfaceRootBlockModelLoader;
import com.dtteam.dynamictrees.model.loader.ThickBranchBlockModelLoader;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterSpriteSourceTypesEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;

@EventBusSubscriber(modid="dynamictrees", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientModEventHandler {
    public static final ResourceLocation BRANCH = DynamicTrees.location("branch");
    public static final ResourceLocation THICK_BRANCH = DynamicTrees.location("thick_branch");
    public static final ResourceLocation SURFACE_ROOT = DynamicTrees.location("surface_root");
    public static final ResourceLocation ROOTS = DynamicTrees.location("roots");
    public static final ResourceLocation LARGE_PALM_FRONDS = DynamicTrees.location("large_palm_fronds");
    public static final ResourceLocation MEDIUM_PALM_FRONDS = DynamicTrees.location("medium_palm_fronds");
    public static final ResourceLocation SMALL_PALM_FRONDS = DynamicTrees.location("small_palm_fronds");

    @OnlyIn(value=Dist.CLIENT)
    public static void discoverWoodColors() {
        Function bakedTextureGetter = Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS);
        for (Family family : Family.REGISTRY.getAll()) {
            family.woodRingColor = 16773550;
            family.woodBarkColor = 11774329;
            if (family == Family.NULL_FAMILY) continue;
            family.getPrimitiveLog().ifPresent(branch -> {
                BlockState state = branch.defaultBlockState();
                family.woodRingColor = ClientModEventHandler.getFaceColor(state, Direction.DOWN, bakedTextureGetter);
                family.woodBarkColor = ClientModEventHandler.getFaceColor(state, Direction.NORTH, bakedTextureGetter);
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int getFaceColor(BlockState state, Direction face, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        List quads = model.getQuads(state, face, RandomSource.create(), ModelData.EMPTY, null);
        if (quads.isEmpty()) {
            quads = model.getQuads(state, null, RandomSource.create(), ModelData.EMPTY, null);
        }
        if (quads.isEmpty()) {
            DynamicTrees.LOG.warn("Could not get color of {} side for {}! Branch needs to be handled manually!", (Object)face, (Object)state.getBlock());
            return 0;
        }
        TextureAtlasSprite sprite = ((BakedQuad)quads.getFirst()).getSprite();
        TextureHelper.PixelBuffer pixelBuffer = new TextureHelper.PixelBuffer(sprite);
        int u = pixelBuffer.w / 16;
        TextureHelper.PixelBuffer center = new TextureHelper.PixelBuffer(u * 8, u * 8);
        pixelBuffer.blit(center, u * -8, u * -8);
        return center.averageColor();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerColorResolversEvent(RegisterColorHandlersEvent.ColorResolvers event) {
        BlockColorMultipliers.register("birch", (state, level, pos, tintIndex) -> FoliageColor.getBirchColor());
        BlockColorMultipliers.register("spruce", (state, level, pos, tintIndex) -> FoliageColor.getEvergreenColor());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerItemColorHandlersEvent(RegisterColorHandlersEvent.Item event) {
        event.register(DTRegistries.DENDRO_POTION.get()::getColor, new ItemLike[]{(ItemLike)DTRegistries.DENDRO_POTION.get()});
        event.register(DTRegistries.STAFF.get()::getColor, new ItemLike[]{(ItemLike)DTRegistries.STAFF.get()});
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerBlockColorHandlersEvent(RegisterColorHandlersEvent.Block event) {
        int white = -1;
        int magenta = 0xFF00FF;
        for (SoilProperties soil : SoilProperties.REGISTRY) {
            if (soil.getBlock().isEmpty()) continue;
            SoilBlock roots = soil.getBlock().get();
            event.register((state, level, pos, tintIndex) -> roots.colorMultiplier(event.getBlockColors(), state, level, pos, tintIndex), new Block[]{roots});
            ClientModEventHandler.setRenderLayerCutoutMipped(roots);
        }
        event.register((state, level, pos, tintIndex) -> ClientModEventHandler.isValidPos((BlockGetter)level, pos) && state.getBlock() instanceof PottedSaplingBlock ? DTRegistries.POTTED_SAPLING.get().getSpecies((BlockGetter)level, pos).saplingColorMultiplier(state, level, pos, tintIndex) : -1, new Block[]{(Block)DTRegistries.POTTED_SAPLING.get()});
        for (Species species : Species.REGISTRY) {
            if (!species.getSapling().isPresent()) continue;
            event.register((state, level, pos, tintIndex) -> ClientModEventHandler.isValidPos((BlockGetter)level, pos) ? species.saplingColorMultiplier(state, level, pos, tintIndex) : -1, new Block[]{species.getSapling().get()});
        }
        for (DynamicLeavesBlock leaves : LeavesProperties.REGISTRY.getAll().stream().filter(lp -> lp.getDynamicLeavesBlock().isPresent()).map(lp -> lp.getDynamicLeavesBlock().get()).collect(Collectors.toSet())) {
            event.register((state, level, pos, tintIndex) -> ClientModEventHandler.isValidPos((BlockGetter)level, pos) && TreeHelper.isLeaves(state.getBlock()) ? ((DynamicLeavesBlock)state.getBlock()).getLeavesProperties().foliageColorMultiplier(state, level, pos) : 0xFF00FF, new Block[]{leaves});
        }
    }

    private static void setRenderLayerCutoutMipped(SoilBlock roots) {
        ItemBlockRenderTypes.setRenderLayer((Block)roots, (RenderType)RenderType.cutoutMipped());
    }

    private static boolean isValidPos(BlockGetter level, BlockPos pos) {
        return level != null && pos != null;
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(DTRegistries.FALLING_TREE.get(), FallingTreeRenderer::new);
        event.registerEntityRenderer(DTRegistries.LINGERING_EFFECTOR.get(), LingeringEffectorRenderer::new);
    }

    @SubscribeEvent
    public static void onModelRegistryEvent(ModelEvent.RegisterGeometryLoaders event) {
        event.register(BRANCH, (IGeometryLoader)new BranchBlockModelLoader());
        event.register(SURFACE_ROOT, (IGeometryLoader)new SurfaceRootBlockModelLoader());
        event.register(THICK_BRANCH, (IGeometryLoader)new ThickBranchBlockModelLoader());
        event.register(ROOTS, (IGeometryLoader)new RootsBlockModelLoader());
        event.register(LARGE_PALM_FRONDS, (IGeometryLoader)new PalmLeavesModelLoader(0));
        event.register(MEDIUM_PALM_FRONDS, (IGeometryLoader)new PalmLeavesModelLoader(1));
        event.register(SMALL_PALM_FRONDS, (IGeometryLoader)new PalmLeavesModelLoader(2));
    }

    @SubscribeEvent
    public static void onModelModifyBakingResultResult(ModelEvent.ModifyBakingResult event) {
        event.getModels().computeIfPresent(new ModelResourceLocation(DynamicTrees.location("potted_sapling"), ""), (k, val) -> new BakedModelBlockPottedSapling((BakedModel)val));
    }

    @SubscribeEvent
    public static void stitchTextureAtlas(RegisterSpriteSourceTypesEvent event) {
        event.register(ThickBranchRingsSource.ID, ThickBranchRingsSource.setType(ThickBranchRingsSource.CODEC));
    }
}

