/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.item;

import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.registry.DTRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class DirtBucket
extends Item {
    public DirtBucket() {
        super(new Item.Properties().stacksTo(1));
        DTRegistries.CREATIVE_TAB_ITEMS.add(this);
        this.craftingRemainingItem = this;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        BlockHitResult blockRayTraceResult = DirtBucket.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (blockRayTraceResult.getType() != HitResult.Type.BLOCK) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
        }
        if (Services.CONFIG.getBoolConfig("dirtBucketPlacesDirt").booleanValue()) {
            BlockPos workingPos;
            if (blockRayTraceResult.getType() != HitResult.Type.BLOCK) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStack);
            }
            BlockPos pos = blockRayTraceResult.getBlockPos();
            if (!world.mayInteract(player, pos)) {
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
            }
            boolean isReplaceable = world.getBlockState(pos).canBeReplaced();
            BlockPos blockPos = workingPos = isReplaceable && blockRayTraceResult.getDirection() == Direction.UP ? pos : pos.relative(blockRayTraceResult.getDirection());
            if (!player.mayUseItemAt(workingPos, blockRayTraceResult.getDirection(), itemStack)) {
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
            }
            if (this.tryPlaceContainedDirt(player, world, workingPos)) {
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                return !player.getAbilities().instabuild ? new InteractionResultHolder(InteractionResult.SUCCESS, (Object)new ItemStack((ItemLike)Items.BUCKET)) : new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
            }
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStack);
    }

    public boolean tryPlaceContainedDirt(@Nullable Player player, Level world, BlockPos posIn) {
        BlockState blockState = world.getBlockState(posIn);
        if (blockState.canBeReplaced()) {
            if (!world.isClientSide && !blockState.isAir()) {
                world.destroyBlock(posIn, true);
            }
            world.playSound(player, posIn, SoundEvents.GRAVEL_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
            world.setBlock(posIn, Blocks.DIRT.defaultBlockState(), 11);
            return true;
        }
        return false;
    }
}

