/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.registry;

import com.dtteam.dynamictrees.api.registry.RegistryHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class NeoForgeRegistryHandler
extends RegistryHandler {
    private static final Method ADD_ENTRIES_METHOD;
    protected final DeferredRegister<Block> blocksDeferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)this.getRegistryName().getNamespace());
    protected final DeferredRegister<Item> itemsDeferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)this.getRegistryName().getNamespace());

    public NeoForgeRegistryHandler() {
    }

    public NeoForgeRegistryHandler(String modId, IEventBus modEventBus) {
        super(ResourceLocation.fromNamespaceAndPath((String)modId, (String)modId));
        RegistryHandler.REGISTRY.register(this);
        modEventBus.register(new RegisterEventHandler<Block>(this.blocksDeferredRegister));
        modEventBus.register(new RegisterEventHandler<Item>(this.itemsDeferredRegister));
    }

    public static RegistryHandler setup(String modId, IEventBus modEventBus) {
        return new NeoForgeRegistryHandler(modId, modEventBus);
    }

    @Override
    @Nullable
    public Supplier<Block> getBlock(ResourceLocation registryName) {
        return DeferredHolder.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)registryName);
    }

    @Override
    @Nullable
    public Supplier<Item> getItem(ResourceLocation registryName) {
        return DeferredHolder.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)registryName);
    }

    @Override
    public <T extends Block> Supplier<T> putBlock(ResourceLocation registryName, Supplier<T> blockSup) {
        if (this.warnIfInvalid("Block", registryName)) {
            return this.getBlock(registryName);
        }
        return this.blocksDeferredRegister.register(registryName.getPath(), blockSup);
    }

    @Override
    public <T extends Item> Supplier<T> putItem(ResourceLocation registryName, Supplier<T> itemSup) {
        if (this.warnIfInvalid("Item", registryName)) {
            return this.getItem(registryName);
        }
        return this.itemsDeferredRegister.register(registryName.getPath(), itemSup);
    }

    private boolean warnIfInvalid(String type, ResourceLocation registryName) {
        if (!this.isValid()) {
            LogManager.getLogger().warn("{} '{}' was added to null registry handler.", (Object)type, (Object)registryName);
        }
        return !this.isValid();
    }

    static {
        try {
            ADD_ENTRIES_METHOD = DeferredRegister.class.getDeclaredMethod("addEntries", RegisterEvent.class);
            ADD_ENTRIES_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static class RegisterEventHandler<T> {
        private final DeferredRegister<T> deferredRegister;

        public RegisterEventHandler(DeferredRegister<T> deferredRegister) {
            this.deferredRegister = deferredRegister;
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onRegister(RegisterEvent event) {
            if (event.getRegistryKey() == this.deferredRegister.getRegistryKey()) {
                try {
                    ADD_ENTRIES_METHOD.invoke(this.deferredRegister, event);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

