/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PreGenerationContext;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.utility.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class MoundGenFeature
extends GenFeature {
    private static final SimpleVoxmap moundMap = new SimpleVoxmap(5, 4, 5, new byte[]{0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 2, 2, 2, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 0, 0, 1, 1, 1, 0, 1, 2, 2, 2, 1, 1, 2, 2, 2, 1, 1, 2, 2, 2, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(2, 3, 2));
    public static final ConfigurationProperty<Integer> MOUND_CUTOFF_RADIUS = ConfigurationProperty.integer("mound_cutoff_radius");
    public static final ConfigurationProperty<Boolean> OFFSET = ConfigurationProperty.bool("offset");

    public MoundGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(MOUND_CUTOFF_RADIUS, OFFSET);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MOUND_CUTOFF_RADIUS, 5)).with(OFFSET, true);
    }

    @Override
    protected BlockPos preGenerate(GenFeatureConfiguration configuration, PreGenerationContext context) {
        LevelAccessor level = context.level();
        BlockPos rootPos = context.pos();
        if (context.radius() >= configuration.get(MOUND_CUTOFF_RADIUS) && context.isWorldGen()) {
            BlockState initialDirtState = level.getBlockState(rootPos);
            BlockState initialUnderState = level.getBlockState(rootPos.below());
            if (configuration.get(OFFSET).booleanValue()) {
                rootPos = rootPos.above();
            }
            for (SimpleVoxmap.VoxmapCell cell : moundMap.getAllNonZeroCells()) {
                BlockState placeState = cell.getValue() == 1 ? initialDirtState : initialUnderState;
                level.setBlock(rootPos.offset((Vec3i)cell.getPos()), placeState, 3);
            }
        }
        return rootPos;
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (context.radius() >= configuration.get(MOUND_CUTOFF_RADIUS) || !context.isWorldGen()) {
            return false;
        }
        LevelAccessor level = context.level();
        BlockPos rootPos = context.pos();
        BlockPos treePos = rootPos.above();
        BlockState belowState = level.getBlockState(rootPos.below());
        BlockState branchState = level.getBlockState(treePos);
        if (TreeHelper.getTreePart(branchState).getRadius(branchState) > 8) {
            for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
                BlockPos dPos = rootPos.offset(dir.getOffset());
                level.setBlock(dPos, context.initialDirtState(), 3);
                level.setBlock(dPos.below(), belowState, 3);
            }
            return true;
        }
        return false;
    }
}

