/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.growthlogic;

import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKit;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKitConfiguration;
import com.dtteam.dynamictrees.systems.growthlogic.context.DirectionManipulationContext;
import com.dtteam.dynamictrees.systems.growthlogic.context.DirectionSelectionContext;
import com.dtteam.dynamictrees.systems.growthlogic.context.PositionalSpeciesContext;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.utility.MathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class MangroveRootsLogic
extends GrowthLogicKit {
    public MangroveRootsLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = context.probMap();
        Direction originDir = context.signal().dir.getOpposite();
        Direction defaultDir = context.signal().defaultDir;
        for (Direction dir : Direction.values()) {
            if (dir.equals((Object)originDir)) continue;
            if (dir.getAxis().isHorizontal()) {
                probMap[dir.get3DDataValue()] = 1;
            }
            if (dir.equals((Object)defaultDir)) {
                probMap[dir.get3DDataValue()] = context.species().getUpProbability();
            }
            if (dir.equals((Object)defaultDir.getOpposite())) {
                probMap[dir.get3DDataValue()] = 0;
            }
            BlockPos deltaPos = context.pos().relative(dir);
            BlockState deltaBlockState = context.level().getBlockState(deltaPos);
            int n = dir.get3DDataValue();
            probMap[n] = probMap[n] + TreeHelper.getTreePart(deltaBlockState).probabilityForBlock(deltaBlockState, (BlockGetter)context.level(), deltaPos, context.branch());
        }
        if (context.signal().isInTrunk()) {
            probMap[defaultDir.ordinal()] = 0;
        }
        probMap[defaultDir.getOpposite().ordinal()] = 0;
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }

    @Override
    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        int[] probMap = configuration.populateDirectionProbabilityMap(new DirectionManipulationContext(context.level(), context.pos(), context.species(), context.branch(), context.signal(), context.branch().getRadius(context.level().getBlockState(context.pos())), new int[6]));
        int choice = MathUtils.selectRandomFromDistribution(context.signal().rand, probMap);
        return Direction.values()[choice != -1 ? choice : 1];
    }

    @Override
    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return 0;
    }

    @Override
    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return context.species().getSignalEnergy();
    }
}

