/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.season;

import com.dtteam.dynamictrees.api.season.ClimateZoneType;
import com.dtteam.dynamictrees.api.season.SeasonGrowthCalculator;
import com.dtteam.dynamictrees.api.season.SeasonManager;
import com.dtteam.dynamictrees.systems.season.NullSeasonGrowthCalculator;
import com.dtteam.dynamictrees.systems.season.NullSeasonProvider;
import com.dtteam.dynamictrees.systems.season.SeasonContext;
import com.dtteam.dynamictrees.systems.season.SeasonProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class NormalSeasonManager
implements SeasonManager {
    public static final Supplier<SeasonManager> NULL = NormalSeasonManager::new;
    private final Map<ResourceLocation, SeasonContext> seasonContextMap = new HashMap<ResourceLocation, SeasonContext>();
    private Function<Level, Tuple<SeasonProvider, SeasonGrowthCalculator>> seasonMapper = w -> new Tuple((Object)new NullSeasonProvider(), (Object)new NullSeasonGrowthCalculator());
    private static final float TROPICAL_THRESHHOLD = 0.8f;
    private BiPredicate<Level, BlockPos> isTropical = (level, rootPos) -> ((Biome)level.getUncachedNoiseBiome(rootPos.getX() >> 2, rootPos.getY() >> 2, rootPos.getZ() >> 2).value()).getBaseTemperature() > 0.8f;

    public NormalSeasonManager() {
    }

    public NormalSeasonManager(Function<Level, Tuple<SeasonProvider, SeasonGrowthCalculator>> seasonMapper) {
        this.seasonMapper = seasonMapper;
    }

    private Tuple<SeasonProvider, SeasonGrowthCalculator> createProvider(Level level) {
        return this.seasonMapper.apply(level);
    }

    private SeasonContext getContext(Level level) {
        return this.seasonContextMap.computeIfAbsent(level.dimension().location(), d -> {
            Tuple<SeasonProvider, SeasonGrowthCalculator> tuple = this.createProvider(level);
            return new SeasonContext((SeasonProvider)tuple.getA(), (SeasonGrowthCalculator)tuple.getB());
        });
    }

    @Override
    public void flushMappings() {
        this.seasonContextMap.clear();
    }

    public void setTropicalPredicate(BiPredicate<Level, BlockPos> predicate) {
        this.isTropical = predicate;
    }

    @Override
    public boolean isTropical(Level level, BlockPos rootPos) {
        return this.isTropical.test(level, rootPos);
    }

    @Override
    public void updateTick(Level level, long dayTime) {
        this.getContext(level).updateTick(level, dayTime);
    }

    @Override
    public float getGrowthFactor(Level level, BlockPos rootPos, float offset) {
        SeasonContext context = this.getContext(level);
        return this.isTropical(level, rootPos) ? context.getTropicalGrowthFactor(offset) : context.getTemperateGrowthFactor(offset);
    }

    @Override
    public float getSeedDropFactor(Level level, BlockPos rootPos, float offset) {
        SeasonContext context = this.getContext(level);
        return this.isTropical(level, rootPos) ? context.getTropicalSeedDropFactor(offset) : context.getTemperateSeedDropFactor(offset);
    }

    @Override
    public float getFruitProductionFactor(Level level, BlockPos rootPos, float offset, boolean getAsScan) {
        if (getAsScan) {
            return this.getFruitProductionFactorAsScan(level.dimension().location(), rootPos, offset);
        }
        SeasonContext context = this.getContext(level);
        return this.isTropical(level, rootPos) ? context.getTropicalFruitProductionFactor(offset) : context.getTemperateFruitProductionFactor(offset);
    }

    @Override
    public Float getSeasonValue(Level level, BlockPos pos) {
        return this.getContext(level).getSeasonProvider().getSeasonValue(level, pos);
    }

    @Override
    public Float getPeakFruitProductionSeasonValue(Level level, BlockPos rootPos, float offset) {
        SeasonContext context = this.getContext(level);
        return this.isTropical(level, rootPos) ? context.getTropicalPeakFruitProductionSeasonValue(offset) : context.getTemperatePeakFruitProductionSeasonValue(offset);
    }

    @Override
    public boolean shouldSnowMelt(Level level, BlockPos pos) {
        return this.getContext(level).getSeasonProvider().shouldSnowMelt(level, pos);
    }

    public float getFruitProductionFactorAsScan(ResourceLocation dimLoc, BlockPos rootPos, float offset) {
        if (this.seasonContextMap.size() > 0) {
            boolean tropical;
            float seasonValue = (float)rootPos.getY() / 64.0f;
            boolean bl = tropical = (float)rootPos.getZ() >= 1.0f;
            if (this.seasonContextMap.containsKey(dimLoc)) {
                SeasonContext context = this.seasonContextMap.get(dimLoc);
                SeasonGrowthCalculator calculator = context.getCalculator();
                return calculator.calcFruitProduction(Float.valueOf(seasonValue + offset), tropical ? ClimateZoneType.TROPICAL : ClimateZoneType.TEMPERATE);
            }
        }
        return 0.0f;
    }
}

