/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.treepack;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.configuration.ConfigurationTemplateResourceLoader;
import com.dtteam.dynamictrees.api.resource.TreeResourceManager;
import com.dtteam.dynamictrees.data.DirtBucketRecipeHandler;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKit;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKitConfiguration;
import com.dtteam.dynamictrees.treepack.ModFileContainer;
import com.dtteam.dynamictrees.treepack.TreePackResources;
import com.dtteam.dynamictrees.treepack.TreesResourceManager;
import com.dtteam.dynamictrees.treepack.loader.BiomePopulatorsResourceLoader;
import com.dtteam.dynamictrees.treepack.loader.FamilyResourceLoader;
import com.dtteam.dynamictrees.treepack.loader.FeatureCancellationResourceLoader;
import com.dtteam.dynamictrees.treepack.loader.FruitResourceLoader;
import com.dtteam.dynamictrees.treepack.loader.JoCodeResourceLoader;
import com.dtteam.dynamictrees.treepack.loader.LeavesPropertiesResourceLoader;
import com.dtteam.dynamictrees.treepack.loader.PodResourceLoader;
import com.dtteam.dynamictrees.treepack.loader.SoilPropertiesResourceLoader;
import com.dtteam.dynamictrees.treepack.loader.SpeciesResourceLoader;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public final class Resources {
    public static final String TREES = "trees";
    public static final TreeResourceManager MANAGER = new TreesResourceManager();
    public static final LeavesPropertiesResourceLoader LEAVES_PROPERTIES_LOADER = new LeavesPropertiesResourceLoader();
    public static final SoilPropertiesResourceLoader SOIL_PROPERTIES_LOADER = new SoilPropertiesResourceLoader();
    public static final FamilyResourceLoader FAMILY_LOADER = new FamilyResourceLoader();
    public static final ConfigurationTemplateResourceLoader<GenFeatureConfiguration, GenFeature> GEN_FEATURE_TEMPLATE_LOADER = new ConfigurationTemplateResourceLoader<GenFeatureConfiguration, GenFeature>("gen_features/configurations", GenFeature.REGISTRY, GenFeatureConfiguration.TEMPLATES);
    public static final ConfigurationTemplateResourceLoader<GrowthLogicKitConfiguration, GrowthLogicKit> GROWTH_LOGIC_KIT_TEMPLATE_LOADER = new ConfigurationTemplateResourceLoader<GrowthLogicKitConfiguration, GrowthLogicKit>("growth_logic_kits/configurations", GrowthLogicKit.REGISTRY, GrowthLogicKitConfiguration.TEMPLATES);
    public static final FruitResourceLoader FRUIT_LOADER = new FruitResourceLoader();
    public static final PodResourceLoader POD_LOADER = new PodResourceLoader();
    public static final SpeciesResourceLoader SPECIES_LOADER = new SpeciesResourceLoader();
    public static final JoCodeResourceLoader JO_CODE_LOADER = new JoCodeResourceLoader();
    public static final FeatureCancellationResourceLoader FEATURE_CANCELLATION_LOADER = new FeatureCancellationResourceLoader();
    public static final BiomePopulatorsResourceLoader BIOME_POPULATORS_LOADER = new BiomePopulatorsResourceLoader();
    private static final PackLocationInfo FLAT_TREE_PACK_INFO = new PackLocationInfo("dynamictrees", (Component)Component.translatable((String)"treePack.dynamictrees.name"), PackSource.BUILT_IN, Optional.empty());

    public static void setupTreesResourceManager() {
        Services.EVENT.postAddResourceLoadersEventPre(MANAGER);
        Resources.addDefaultLoaders();
        Services.EVENT.postAddResourceLoadersEventPost(MANAGER);
        MANAGER.registerAppliers();
        Resources.registerModTreePacks();
        Resources.registerFlatTreePack();
        DynamicTrees.LOG.debug("Successfully loaded {} tree packs.", (Object)MANAGER.listPacks().count());
    }

    private static void addDefaultLoaders() {
        MANAGER.addLoaders(LEAVES_PROPERTIES_LOADER, SOIL_PROPERTIES_LOADER, FAMILY_LOADER, GEN_FEATURE_TEMPLATE_LOADER, GROWTH_LOGIC_KIT_TEMPLATE_LOADER, FRUIT_LOADER, POD_LOADER, SPECIES_LOADER, JO_CODE_LOADER, FEATURE_CANCELLATION_LOADER, BIOME_POPULATORS_LOADER);
    }

    private static void registerModTreePacks() {
        Services.PLATFORM.getMods().forEach(Resources::addModTreePack);
    }

    private static void addModTreePack(ModFileContainer modFile) {
        Optional<Path> treesPath = modFile.findResource(TREES);
        if (treesPath.isEmpty()) {
            DynamicTrees.LOG.error("Error loading Tree Pack for mod {}", (Object)modFile.getModId());
            return;
        }
        Path absTreesPath = treesPath.get().toAbsolutePath();
        if (Files.exists(absTreesPath, new LinkOption[0])) {
            MANAGER.addPack(new TreePackResources(new PackLocationInfo(modFile.getModId(), (Component)Component.translatable((String)("treePack." + modFile.getModId() + ".name")), PackSource.WORLD, Optional.empty()), absTreesPath.toAbsolutePath()));
        }
    }

    private static void registerFlatTreePack() {
        File mainTreeFolder = Resources.getTreeFolder();
        MANAGER.addPack(new TreePackResources(FLAT_TREE_PACK_INFO, mainTreeFolder.toPath().toAbsolutePath()));
    }

    private static File getTreeFolder() {
        File mainTreeFolder = new File("trees/");
        if (!mainTreeFolder.exists() && !mainTreeFolder.mkdir()) {
            throw new RuntimeException("Failed to create \"trees\" folder in your Minecraft directory.");
        }
        return mainTreeFolder;
    }

    public static class ReloadListener
    implements PreparableReloadListener {
        private RecipeManager recipeManager;

        public ReloadListener(RecipeManager recipeManager) {
            this.recipeManager = recipeManager;
        }

        public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            CompletableFuture[] futures = MANAGER.prepareReload(gameExecutor, backgroundExecutor);
            return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(futures).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0))).thenAcceptAsync(v -> MANAGER.reload(futures), gameExecutor)).thenRunAsync(this::registerDirtBucketRecipes, gameExecutor);
        }

        private void registerDirtBucketRecipes() {
            if (!Services.CONFIG.getBoolConfig("generateDirtBucketRecipes").booleanValue() && !Services.CONFIG.getBoolConfig("generateMegaSeedRecipe").booleanValue()) {
                return;
            }
            if (this.recipeManager == null) {
                MinecraftServer server = Services.MISC.getCurrentServer();
                if (server == null) {
                    return;
                }
                this.recipeManager = server.getRecipeManager();
            }
            HashMultimap recipes = HashMultimap.create();
            this.recipeManager.byType.forEach((arg_0, arg_1) -> ((Multimap)recipes).put(arg_0, arg_1));
            DirtBucketRecipeHandler.registerDirtBucketRecipes(recipes.get((Object)RecipeType.CRAFTING));
            this.recipeManager.byType = ImmutableMultimap.copyOf((Multimap)recipes);
        }
    }
}

