/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.worldgen;

import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.network.NodeInspector;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.systems.nodemapper.CoderNode;
import com.dtteam.dynamictrees.systems.nodemapper.FindEndsNode;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.family.UndergroundRootsFamily;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.worldgen.DynamicTreeGenerationContext;
import com.dtteam.dynamictrees.worldgen.JoCode;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RootsJoCode
extends JoCode {
    public RootsJoCode(String code) {
        super(code);
    }

    public RootsJoCode(Level level, BlockPos rootPos, Direction facing) {
        super(level, rootPos, facing);
    }

    @Override
    protected void getCodeFromWorld(Level level, BlockPos rootPos, Direction facing) {
        Optional<BranchBlock> branch = TreeHelper.getBranchOpt(level.getBlockState(rootPos.below()));
        if (branch.isPresent()) {
            CoderNode coder = new CoderNode();
            branch.get().analyse(level.getBlockState(rootPos), (LevelAccessor)level, rootPos, Direction.UP, new MapSignal(coder));
            this.instructions = coder.compile(this);
            this.rotate(facing);
        }
    }

    @Override
    public void generate(DynamicTreeGenerationContext context) {
        int rootRadius;
        LevelAccessor level = context.level();
        Species species = context.species();
        int radius = context.radius();
        boolean worldGen = context.isWorldGen();
        this.setFacing(context.facing());
        BlockPos.MutableBlockPos rootPos = context.rootPos();
        if (rootPos == BlockPos.ZERO) {
            return;
        }
        BlockState rootState = level.getBlockState((BlockPos)context.rootPos());
        Block block = rootState.getBlock();
        if (block instanceof SoilBlock) {
            SoilBlock rooty = (SoilBlock)block;
            rootRadius = rooty.updateRadius(level, rootState, (BlockPos)context.rootPos(), 2, false);
        } else {
            rootRadius = 8;
        }
        this.generateFork(level, species, 0, (BlockPos)rootPos, false);
        BlockPos rootsPos = rootPos.below();
        BlockState rootsState = level.getBlockState(rootsPos);
        BranchBlock firstBranch = TreeHelper.getBranch(rootsState);
        if (firstBranch == null) {
            return;
        }
        SimpleVoxmap rootsMap = new SimpleVoxmap(radius * 2 + 1, species.getWorldGenLeafMapHeight(), radius * 2 + 1).setMapAndCenter(rootsPos, new BlockPos(radius, species.getWorldGenLeafMapHeight(), radius));
        NodeInspector inflator = species.getNodeInflator(rootsMap, rootRadius);
        FindEndsNode endFinder = new FindEndsNode();
        MapSignal signal = new MapSignal(inflator, endFinder);
        signal.destroyLoopedNodes = this.careful;
        firstBranch.analyse(rootsState, level, rootsPos, Direction.UP, signal);
        if (signal.foundRoot || signal.overflow) {
            this.tryGenerateAgain(context, worldGen, rootsPos, rootsState, endFinder);
            return;
        }
        List<BlockPos> endPoints = endFinder.getEnds();
        species.handleRot(level, endPoints, (BlockPos)rootPos, rootsPos, 0, context.isWorldGen());
    }

    @Override
    protected boolean setBlockForGeneration(LevelAccessor level, Species species, BlockPos pos, Direction dir, boolean careful, boolean isLast) {
        Family family;
        if (this.isFreeToSetBlock(level, pos, species) && (!careful || this.isClearOfNearbyBranches(level, pos, dir.getOpposite())) && (family = species.getFamily()) instanceof UndergroundRootsFamily) {
            UndergroundRootsFamily family2 = (UndergroundRootsFamily)family;
            family2.getBranchForRootsPlacement(level, species, pos).ifPresent(branch -> branch.setRadius(level, pos, family2.getPrimaryRootThickness(), null, careful ? 3 : 2));
            return false;
        }
        return true;
    }

    @Override
    protected boolean isFreeToSetBlock(LevelAccessor level, BlockPos pos, Species species) {
        return species.getFamily().isAcceptableSoilForRootSystem(level.getBlockState(pos)) || super.isFreeToSetBlock(level, pos, species);
    }
}

