/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.worldgen.feature;

import com.dtteam.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.dtteam.dynamictrees.api.worldgen.GroundFinder;
import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.api.worldgen.RandomXOR;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.data.tags.DTBlockTags;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.poissondisc.PoissonDisc;
import com.dtteam.dynamictrees.systems.poissondisc.UniversalPoissonDiscProvider;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.CoordUtils;
import com.dtteam.dynamictrees.worldgen.BiomeDatabase;
import com.dtteam.dynamictrees.worldgen.BiomeDatabases;
import com.dtteam.dynamictrees.worldgen.DynamicTreeGenerationContext;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DynamicTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public static final UniversalPoissonDiscProvider DISC_PROVIDER = new UniversalPoissonDiscProvider();
    protected static final RandomXOR RANDOM = new RandomXOR();
    private static Block[] concreteBlocks;

    public static void setup() {
        concreteBlocks = (Block[])Arrays.stream(DyeColor.values()).map(color -> (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)(color.getName() + "_concrete")))).toArray(Block[]::new);
    }

    public DynamicTreeFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        LevelContext levelContext = LevelContext.create((LevelAccessor)context.level());
        if (BiomeDatabases.isBlacklisted(levelContext.dimensionName())) {
            return false;
        }
        BiomeDatabase biomeDatabase = BiomeDatabases.getDimensionalOrDefault(levelContext.dimensionName());
        ChunkPos chunkPos = new ChunkPos(context.origin());
        DISC_PROVIDER.getPoissonDiscs(levelContext, chunkPos).forEach(disc -> this.generateTrees(levelContext, biomeDatabase, (PoissonDisc)disc, context.origin()));
        return true;
    }

    protected void generateTrees(LevelContext levelContext, BiomeDatabase biomeDatabase, PoissonDisc disc, BlockPos originPos) {
        BlockPos basePos = new BlockPos(disc.x, originPos.getY(), disc.z);
        Holder<Biome> biome = DynamicTreeFeature.getNoiseBiome(levelContext, basePos);
        Heightmap.Types heightmap = Heightmap.Types.valueOf((String)biomeDatabase.getHeightmap(biome).toUpperCase());
        for (BlockPos groundPos : GroundFinder.getGroundFinder(levelContext.level()).findGround(levelContext.accessor(), basePos, heightmap)) {
            BiomeDatabase.Entry entry = biomeDatabase.getEntry(DynamicTreeFeature.getNoiseBiome(levelContext, groundPos));
            this.generateTree(levelContext, entry, disc, originPos, groundPos);
        }
    }

    protected static Holder<Biome> getNoiseBiome(LevelContext levelContext, BlockPos pos) {
        return levelContext.level().getUncachedNoiseBiome(pos.getX() >> 2, pos.getY() >> 2, pos.getZ() >> 2);
    }

    public static boolean validTreePos(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.isStateAtPosition(pPos, state -> state.isAir() || state.is(BlockTags.REPLACEABLE_BY_TREES) || DynamicTreeFeature.isFoliage(pLevel, pPos));
    }

    public static boolean isFoliage(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.isStateAtPosition(pPos, state -> state.is(DTBlockTags.FOLIAGE));
    }

    protected GeneratorResult generateTree(LevelContext levelContext, BiomeDatabase.EntryReader biomeEntry, PoissonDisc circle, BlockPos originPos, BlockPos groundPos) {
        if (groundPos == BlockPos.ZERO) {
            return GeneratorResult.NO_GROUND;
        }
        if (levelContext.accessor().getBlockState(groundPos).getBlock() instanceof SoilBlock) {
            return GeneratorResult.ALREADY_GENERATED;
        }
        RANDOM.setXOR(groundPos);
        BlockState dirtState = levelContext.accessor().getBlockState(groundPos);
        GeneratorResult result = GeneratorResult.GENERATED;
        BiomePropertySelectors.SpeciesSelector speciesSelector = this.getSpeciesSelector(biomeEntry);
        BiomePropertySelectors.SpeciesSelection speciesSelection = speciesSelector.getSpecies(groundPos, dirtState, (RandomSource)RANDOM);
        if (!biomeEntry.isBlacklisted() && speciesSelection.isHandled()) {
            Species species = speciesSelection.getSpecies();
            if (species.isValid()) {
                if (species.isAcceptableSoilForWorldgen(levelContext.accessor(), groundPos, dirtState)) {
                    if (this.getChanceSelector(biomeEntry).getChance((RandomSource)RANDOM, species, circle.radius) == BiomePropertySelectors.Chance.OK) {
                        Holder<Biome> biome = DynamicTreeFeature.getNoiseBiome(levelContext, groundPos);
                        if (!species.generate(new DynamicTreeGenerationContext(levelContext, species, originPos, groundPos.mutable(), biome, CoordUtils.getRandomDir((RandomSource)RANDOM), circle.radius, true))) {
                            result = GeneratorResult.FAIL_GENERATION;
                        }
                    } else {
                        result = GeneratorResult.FAIL_CHANCE;
                    }
                } else {
                    result = GeneratorResult.FAIL_SOIL;
                }
            } else {
                result = GeneratorResult.NO_TREE;
            }
        } else {
            result = GeneratorResult.UNHANDLED_BIOME;
        }
        if (Services.CONFIG.getBoolConfig("debug").booleanValue()) {
            this.generateConcreteCircle(levelContext.accessor(), circle, groundPos.getY(), result);
        }
        return result;
    }

    protected BiomePropertySelectors.SpeciesSelector getSpeciesSelector(BiomeDatabase.EntryReader biomeEntry) {
        return biomeEntry.getSpeciesSelector();
    }

    protected BiomePropertySelectors.ChanceSelector getChanceSelector(BiomeDatabase.EntryReader biomeEntry) {
        return biomeEntry.getChanceSelector();
    }

    private void generateConcreteCircle(LevelAccessor level, PoissonDisc circle, int h, GeneratorResult resultType) {
        for (int ix = -circle.radius; ix <= circle.radius; ++ix) {
            for (int iz = -circle.radius; iz <= circle.radius; ++iz) {
                if (!circle.isEdge(circle.x + ix, circle.z + iz)) continue;
                level.setBlock(new BlockPos(circle.x + ix, h, circle.z + iz), concreteBlocks[(circle.x ^ circle.z) & 0xF].defaultBlockState(), 0);
            }
        }
        if (resultType != GeneratorResult.GENERATED) {
            BlockPos pos = new BlockPos(circle.x, h, circle.z);
            level.setBlock(pos, resultType.getColoredBlock(), 0);
            level.setBlock(pos.above(), resultType.getColoredBlock(), 0);
        }
    }

    public static enum GeneratorResult {
        GENERATED(DyeColor.WHITE),
        NO_TREE(DyeColor.BLACK),
        UNHANDLED_BIOME(DyeColor.YELLOW),
        FAIL_SOIL(DyeColor.BROWN),
        FAIL_CHANCE(DyeColor.BLUE),
        FAIL_GENERATION(DyeColor.RED),
        NO_GROUND(DyeColor.PURPLE),
        ALREADY_GENERATED(DyeColor.GRAY);

        private final DyeColor color;

        private GeneratorResult(DyeColor color) {
            this.color = color;
        }

        public DyeColor getColor() {
            return this.color;
        }

        public BlockState getColoredBlock() {
            return concreteBlocks[this.color.getId()].defaultBlockState();
        }
    }
}

