/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.worldgen.holderset;

import com.dtteam.dynamictrees.registry.NeoForgeRegistryLoader;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.registries.holdersets.CompositeHolderSet;
import net.neoforged.neoforge.registries.holdersets.HolderSetType;
import net.neoforged.neoforge.registries.holdersets.ICustomHolderSet;

public class IncludesExcludesHolderSet<T>
extends CompositeHolderSet<T> {
    private final HolderSet<T> includes;
    private final HolderSet<T> excludes;

    public static <T> MapCodec<? extends ICustomHolderSet<T>> mapCodec(ResourceKey<? extends Registry<T>> registryKey, Codec<Holder<T>> holderCodec, boolean forceList) {
        Codec holderSetCodec = HolderSetCodec.create(registryKey, holderCodec, (boolean)forceList);
        return RecordCodecBuilder.mapCodec(builder -> builder.group((App)holderSetCodec.fieldOf("includes").forGetter(IncludesExcludesHolderSet::includes), (App)holderSetCodec.fieldOf("excludes").forGetter(IncludesExcludesHolderSet::excludes)).apply((Applicative)builder, IncludesExcludesHolderSet::new));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, ? extends ICustomHolderSet<T>> streamCodec(ResourceKey<? extends Registry<T>> resourceKey) {
        return StreamCodec.composite((StreamCodec)ByteBufCodecs.holderSet(resourceKey), IncludesExcludesHolderSet::doesInclude, (StreamCodec)ByteBufCodecs.holderSet(resourceKey), IncludesExcludesHolderSet::doesExclude, IncludesExcludesHolderSet::new);
    }

    private static <T> HolderSet<T> doesInclude(ICustomHolderSet<T> holders) {
        return ((IncludesExcludesHolderSet)holders).includes;
    }

    private static <T> HolderSet<T> doesExclude(ICustomHolderSet<T> holders) {
        return ((IncludesExcludesHolderSet)holders).excludes;
    }

    public IncludesExcludesHolderSet(HolderSet<T> includes, HolderSet<T> excludes) {
        super(List.of(includes, excludes));
        this.includes = includes;
        this.excludes = excludes;
    }

    public HolderSet<T> includes() {
        return this.includes;
    }

    public List<HolderSet<T>> getIncludeComponents() {
        List list;
        HolderSet<T> holderSet = this.includes;
        if (holderSet instanceof CompositeHolderSet) {
            CompositeHolderSet compositeHolderSet = (CompositeHolderSet)holderSet;
            list = compositeHolderSet.getComponents();
        } else {
            list = null;
        }
        return list;
    }

    public List<HolderSet<T>> getExcludeComponents() {
        List list;
        HolderSet<T> holderSet = this.excludes;
        if (holderSet instanceof CompositeHolderSet) {
            CompositeHolderSet compositeHolderSet = (CompositeHolderSet)holderSet;
            list = compositeHolderSet.getComponents();
        } else {
            list = null;
        }
        return list;
    }

    public void clear() {
        this.getIncludeComponents().clear();
        this.getExcludeComponents().clear();
    }

    public HolderSet<T> excludes() {
        return this.excludes;
    }

    protected Set<Holder<T>> createSet() {
        return this.includes.stream().filter(holder -> !this.excludes.contains(holder)).collect(Collectors.toSet());
    }

    public HolderSetType type() {
        return NeoForgeRegistryLoader.INCLUDES_EXCLUDES_HOLDER_SET_TYPE.get();
    }

    public static class Type
    implements HolderSetType {
        public <T> MapCodec<? extends ICustomHolderSet<T>> makeCodec(ResourceKey<? extends Registry<T>> resourceKey, Codec<Holder<T>> codec, boolean b) {
            return IncludesExcludesHolderSet.mapCodec(resourceKey, codec, b);
        }

        public <T> StreamCodec<RegistryFriendlyByteBuf, ? extends ICustomHolderSet<T>> makeStreamCodec(ResourceKey<? extends Registry<T>> resourceKey) {
            return IncludesExcludesHolderSet.streamCodec(resourceKey);
        }
    }
}

